/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.incubator.semconv.net;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.AttributesBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.incubator.semconv.net.PeerServiceResolver;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.instrumenter.AttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.semconv.network.ServerAttributesGetter;
import javax.annotation.Nullable;

public final class PeerServiceAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private static final AttributeKey<String> PEER_SERVICE = AttributeKey.stringKey("peer.service");
    private final ServerAttributesGetter<REQUEST> attributesGetter;
    private final PeerServiceResolver peerServiceResolver;

    PeerServiceAttributesExtractor(ServerAttributesGetter<REQUEST> attributesGetter, PeerServiceResolver peerServiceResolver) {
        this.attributesGetter = attributesGetter;
        this.peerServiceResolver = peerServiceResolver;
    }

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(ServerAttributesGetter<REQUEST> attributesGetter, PeerServiceResolver peerServiceResolver) {
        return new PeerServiceAttributesExtractor<REQUEST, RESPONSE>(attributesGetter, peerServiceResolver);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Integer serverPort;
        if (this.peerServiceResolver.isEmpty()) {
            return;
        }
        String serverAddress = this.attributesGetter.getServerAddress(request);
        String peerService = this.mapToPeerService(serverAddress, serverPort = this.attributesGetter.getServerPort(request));
        if (peerService != null) {
            attributes.put(PEER_SERVICE, peerService);
        }
    }

    @Nullable
    private String mapToPeerService(@Nullable String host, @Nullable Integer port) {
        if (host == null) {
            return null;
        }
        return this.peerServiceResolver.resolveService(host, port, null);
    }
}

