/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.incubator.semconv.util;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.internal.ClassNames;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.internal.cache.Cache;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SpanNames {
    private static final Cache<Class<?>, Map<String, String>> spanNameCaches = Cache.weak();

    public static String fromMethod(Method method) {
        return SpanNames.fromMethod(method.getDeclaringClass(), method.getName());
    }

    public static String fromMethod(Class<?> clazz, String methodName) {
        Map spanNameCache = spanNameCaches.computeIfAbsent(clazz, c -> new ConcurrentHashMap());
        String spanName = (String)spanNameCache.get(methodName);
        if (spanName != null) {
            return spanName;
        }
        spanName = ClassNames.simpleName(clazz) + "." + methodName;
        spanNameCache.put(methodName, spanName);
        return spanName;
    }

    private SpanNames() {
    }
}

