/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.semconv.http;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;

final class ForwardedUrlSchemeProvider<REQUEST>
implements Function<REQUEST, String> {
    private final HttpServerAttributesGetter<REQUEST, ?> getter;

    ForwardedUrlSchemeProvider(HttpServerAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @Override
    public String apply(REQUEST request) {
        String proto;
        for (String forwarded : this.getter.getHttpRequestHeader(request, "forwarded")) {
            proto = ForwardedUrlSchemeProvider.extractProtoFromForwardedHeader(forwarded);
            if (proto == null) continue;
            return proto;
        }
        for (String forwardedProto : this.getter.getHttpRequestHeader(request, "x-forwarded-proto")) {
            proto = ForwardedUrlSchemeProvider.extractProtoFromForwardedProtoHeader(forwardedProto);
            if (proto == null) continue;
            return proto;
        }
        return null;
    }

    @Nullable
    private static String extractProtoFromForwardedHeader(String forwarded) {
        int start = forwarded.toLowerCase(Locale.ROOT).indexOf("proto=");
        if (start < 0) {
            return null;
        }
        if ((start += 6) >= forwarded.length() - 1) {
            return null;
        }
        return ForwardedUrlSchemeProvider.extractProto(forwarded, start);
    }

    @Nullable
    private static String extractProtoFromForwardedProtoHeader(String forwardedProto) {
        return ForwardedUrlSchemeProvider.extractProto(forwardedProto, 0);
    }

    @Nullable
    private static String extractProto(String forwarded, int start) {
        if (forwarded.length() == start) {
            return null;
        }
        if (forwarded.charAt(start) == '\"') {
            return ForwardedUrlSchemeProvider.extractProto(forwarded, start + 1);
        }
        for (int i = start; i < forwarded.length(); ++i) {
            char c = forwarded.charAt(i);
            if (c != ',' && c != ';' && c != '\"') continue;
            if (i == start) {
                return null;
            }
            return forwarded.substring(start, i);
        }
        return forwarded.substring(start);
    }
}

