/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.semconv.http;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.trace.Span;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.instrumenter.ContextCustomizer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.internal.HttpRouteState;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.semconv.http.HttpServerRouteBiGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.semconv.http.HttpServerRouteBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.semconv.http.HttpServerRouteGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.api.semconv.http.HttpServerRouteSource;
import javax.annotation.Nullable;

public final class HttpServerRoute {
    public static <REQUEST> ContextCustomizer<REQUEST> create(HttpServerAttributesGetter<REQUEST, ?> getter) {
        return HttpServerRoute.builder(getter).build();
    }

    public static <REQUEST> HttpServerRouteBuilder<REQUEST> builder(HttpServerAttributesGetter<REQUEST, ?> getter) {
        return new HttpServerRouteBuilder<REQUEST>(getter);
    }

    private HttpServerRoute() {
    }

    public static void update(Context context, HttpServerRouteSource source2, @Nullable String httpRoute) {
        HttpServerRoute.update(context, source2, ConstantAdapter.INSTANCE, httpRoute);
    }

    public static <T> void update(Context context, HttpServerRouteSource source2, HttpServerRouteGetter<T> httpRouteGetter, T arg1) {
        HttpServerRoute.update(context, source2, OneArgAdapter.getInstance(), arg1, httpRouteGetter);
    }

    public static <T, U> void update(Context context, HttpServerRouteSource source2, HttpServerRouteBiGetter<T, U> httpRouteGetter, T arg1, U arg2) {
        String route;
        boolean onlyIfBetterRoute;
        HttpRouteState httpRouteState = HttpRouteState.fromContextOrNull(context);
        if (httpRouteState == null) {
            return;
        }
        Span serverSpan = httpRouteState.getSpan();
        if (serverSpan == null) {
            return;
        }
        boolean bl = onlyIfBetterRoute = !source2.useFirst && source2.order == httpRouteState.getUpdatedBySourceOrder();
        if (!(source2.order <= httpRouteState.getUpdatedBySourceOrder() && !onlyIfBetterRoute || (route = httpRouteGetter.get(context, arg1, arg2)) == null || route.isEmpty() || onlyIfBetterRoute && !HttpServerRoute.isBetterRoute(httpRouteState, route))) {
            HttpServerRoute.updateSpanName(serverSpan, httpRouteState, route);
            httpRouteState.update(context, source2.order, route);
        }
    }

    private static boolean isBetterRoute(HttpRouteState httpRouteState, String name) {
        String route = httpRouteState.getRoute();
        int routeLength = route == null ? 0 : route.length();
        return name.length() > routeLength;
    }

    private static void updateSpanName(Span serverSpan, HttpRouteState httpRouteState, String route) {
        String method = httpRouteState.getMethod();
        serverSpan.updateName(method + " " + route);
    }

    @Nullable
    static String get(Context context) {
        HttpRouteState httpRouteState = HttpRouteState.fromContextOrNull(context);
        return httpRouteState == null ? null : httpRouteState.getRoute();
    }

    private static final class ConstantAdapter
    implements HttpServerRouteGetter<String> {
        private static final ConstantAdapter INSTANCE = new ConstantAdapter();

        private ConstantAdapter() {
        }

        @Override
        @Nullable
        public String get(Context context, String route) {
            return route;
        }
    }

    private static final class OneArgAdapter<T>
    implements HttpServerRouteBiGetter<T, HttpServerRouteGetter<T>> {
        private static final OneArgAdapter<Object> INSTANCE = new OneArgAdapter();

        private OneArgAdapter() {
        }

        static <T> OneArgAdapter<T> getInstance() {
            return INSTANCE;
        }

        @Override
        @Nullable
        public String get(Context context, T arg, HttpServerRouteGetter<T> httpRouteGetter) {
            return httpRouteGetter.get(context, arg);
        }
    }
}

