/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.resources;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.resources.ContainerResource;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

class CgroupV2ContainerIdExtractor {
    private static final Logger logger = Logger.getLogger(CgroupV2ContainerIdExtractor.class.getName());
    static final Path V2_CGROUP_PATH = Paths.get("/proc/self/mountinfo", new String[0]);
    private static final Pattern CONTAINER_ID_RE = Pattern.compile("^[0-9a-f]{64}$");
    private static final Pattern CONTAINERD_CONTAINER_ID_RE = Pattern.compile("cri-containerd:[0-9a-f]{64}");
    private static final Pattern CRIO_CONTAINER_ID_RE = Pattern.compile("\\/crio-[0-9a-f]{64}");
    private final ContainerResource.Filesystem filesystem;

    CgroupV2ContainerIdExtractor() {
        this(ContainerResource.FILESYSTEM_INSTANCE);
    }

    CgroupV2ContainerIdExtractor(ContainerResource.Filesystem filesystem) {
        this.filesystem = filesystem;
    }

    Optional<String> extractContainerId() {
        List<String> fileAsList;
        if (!this.filesystem.isReadable(V2_CGROUP_PATH)) {
            return Optional.empty();
        }
        try {
            fileAsList = this.filesystem.lineList(V2_CGROUP_PATH);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to read v2 cgroup path", e);
            return Optional.empty();
        }
        Optional<String> optCid = fileAsList.stream().filter(line -> line.contains("/crio-")).map(CRIO_CONTAINER_ID_RE::matcher).filter(Matcher::find).findFirst().map(matcher -> matcher.group(0).substring(6));
        if (optCid.isPresent()) {
            return optCid;
        }
        optCid = fileAsList.stream().filter(line -> line.contains("cri-containerd:")).map(CONTAINERD_CONTAINER_ID_RE::matcher).filter(Matcher::find).findFirst().map(matcher -> matcher.group(0).substring(15));
        if (optCid.isPresent()) {
            return optCid;
        }
        return fileAsList.stream().filter(line -> line.contains("/containers/")).flatMap(line -> Stream.of(line.split("/"))).map(CONTAINER_ID_RE::matcher).filter(Matcher::matches).reduce((first, second) -> second).map(matcher -> matcher.group(0));
    }
}

