/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.resources;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.AttributesBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.resources.Resource;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class HostResource {
    private static final AttributeKey<String> HOST_ARCH = AttributeKey.stringKey("host.arch");
    private static final AttributeKey<String> HOST_NAME = AttributeKey.stringKey("host.name");
    private static final Resource INSTANCE = HostResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    static Resource buildResource() {
        AttributesBuilder attributes = Attributes.builder();
        try {
            attributes.put(HOST_NAME, InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        String hostArch = null;
        try {
            hostArch = System.getProperty("os.arch");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (hostArch != null) {
            attributes.put(HOST_ARCH, hostArch);
        }
        return Resource.create(attributes.build(), "https://opentelemetry.io/schemas/1.24.0");
    }

    private HostResource() {
    }
}

