/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.resources;

import com.google.auto.service.AutoService;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.resources.AttributeProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.resources.AttributeResourceProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.resources.MainJarPathFinder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.instrumentation.resources.MainJarPathHolder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.ResourceProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.semconv.ServiceAttributes;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

@AutoService(value={ResourceProvider.class})
public final class ManifestResourceProvider
extends AttributeResourceProvider<Manifest> {
    private static final Logger logger = Logger.getLogger(ManifestResourceProvider.class.getName());

    public ManifestResourceProvider() {
        this(MainJarPathHolder::getJarPath, ManifestResourceProvider::readManifest);
    }

    private ManifestResourceProvider(final Supplier<Optional<Path>> jarPathSupplier, final Function<Path, Optional<Manifest>> manifestReader) {
        super(new AttributeProvider<Manifest>(){

            @Override
            public Optional<Manifest> readData() {
                return ((Optional)jarPathSupplier.get()).flatMap(manifestReader);
            }

            @Override
            public void registerAttributes(AttributeProvider.Builder<Manifest> builder) {
                builder.add(ServiceAttributes.SERVICE_NAME, manifest -> {
                    String serviceName = manifest.getMainAttributes().getValue("Implementation-Title");
                    return Optional.ofNullable(serviceName);
                }).add(ServiceAttributes.SERVICE_VERSION, manifest -> {
                    String serviceVersion = manifest.getMainAttributes().getValue("Implementation-Version");
                    return Optional.ofNullable(serviceVersion);
                });
            }
        });
    }

    ManifestResourceProvider(MainJarPathFinder jarPathFinder, Function<Path, Optional<Manifest>> manifestReader) {
        this(() -> Optional.ofNullable(jarPathFinder.detectJarPath()), manifestReader);
    }

    private static Optional<Manifest> readManifest(Path jarPath) {
        Optional<Manifest> optional;
        JarFile jarFile = new JarFile(jarPath.toFile(), false);
        try {
            optional = Optional.of(jarFile.getManifest());
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                logger.log(Level.WARNING, "Error reading manifest", exception);
                return Optional.empty();
            }
        }
        jarFile.close();
        return optional;
    }

    @Override
    public int order() {
        return 300;
    }
}

