/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okio;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.kotlin.Metadata;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.kotlin.jvm.internal.Intrinsics;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.kotlin.jvm.internal.SourceDebugExtension;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okio.Buffer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okio.Okio;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okio.Segment;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okio.SegmentPool;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okio.Source;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okio.Timeout;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.org.jetbrains.annotations.NotNull;
import java.io.IOException;
import java.io.InputStream;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/prometheus/metrics/shaded/io_opentelemetry_2_10_0_alpha/okio/InputStreamSource;", "Lio/prometheus/metrics/shaded/io_opentelemetry_2_10_0_alpha/okio/Source;", "input", "Ljava/io/InputStream;", "timeout", "Lio/prometheus/metrics/shaded/io_opentelemetry_2_10_0_alpha/okio/Timeout;", "(Ljava/io/InputStream;Lokio/Timeout;)V", "close", "", "read", "", "sink", "Lio/prometheus/metrics/shaded/io_opentelemetry_2_10_0_alpha/okio/Buffer;", "byteCount", "toString", "", "io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.okio"})
@SourceDebugExtension(value={"SMAP\nJvmOkio.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmOkio.kt\nokio/InputStreamSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,239:1\n1#2:240\n86#3:241\n*S KotlinDebug\n*F\n+ 1 JvmOkio.kt\nokio/InputStreamSource\n*L\n92#1:241\n*E\n"})
class InputStreamSource
implements Source {
    @NotNull
    private final InputStream input;
    @NotNull
    private final Timeout timeout;

    public InputStreamSource(@NotNull InputStream input, @NotNull Timeout timeout2) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(timeout2, "timeout");
        this.input = input;
        this.timeout = timeout2;
    }

    @Override
    public long read(@NotNull Buffer sink2, long byteCount) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        if (byteCount == 0L) {
            return 0L;
        }
        if (!(byteCount >= 0L)) {
            boolean $i$a$-require-InputStreamSource$read$22 = false;
            String $i$a$-require-InputStreamSource$read$22 = "byteCount < 0: " + byteCount;
            throw new IllegalArgumentException($i$a$-require-InputStreamSource$read$22.toString());
        }
        try {
            this.timeout.throwIfReached();
            Segment tail = sink2.writableSegment$okio(1);
            int b$iv = 8192 - tail.limit;
            boolean $i$f$minOf = false;
            int maxToCopy = (int)Math.min(byteCount, (long)b$iv);
            int bytesRead = this.input.read(tail.data, tail.limit, maxToCopy);
            if (bytesRead == -1) {
                if (tail.pos == tail.limit) {
                    sink2.head = tail.pop();
                    SegmentPool.recycle(tail);
                }
                return -1L;
            }
            tail.limit += bytesRead;
            sink2.setSize$okio(sink2.size() + (long)bytesRead);
            return bytesRead;
        }
        catch (AssertionError e) {
            if (Okio.isAndroidGetsocknameError(e)) {
                throw new IOException((Throwable)((Object)e));
            }
            throw e;
        }
    }

    @Override
    public void close() {
        this.input.close();
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return this.timeout;
    }

    @NotNull
    public String toString() {
        return "source(" + this.input + ')';
    }
}

