/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.internal.NamedSpiManager;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.ConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.internal.ConfigurableMetricReaderProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.export.MetricExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.export.MetricReader;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.export.PeriodicMetricReader;
import java.io.Closeable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

final class MetricExporterConfiguration {
    private static final Duration DEFAULT_EXPORT_INTERVAL = Duration.ofMinutes(1L);
    private static final Map<String, String> EXPORTER_ARTIFACT_ID_BY_NAME = new HashMap<String, String>();
    private static final Map<String, String> READER_ARTIFACT_ID_BY_NAME;

    static MetricReader configureReader(String name, ConfigProperties config, SpiHelper spiHelper, BiFunction<? super MetricReader, ConfigProperties, ? extends MetricReader> metricReaderCustomizer, BiFunction<? super MetricExporter, ConfigProperties, ? extends MetricExporter> metricExporterCustomizer, List<Closeable> closeables) {
        NamedSpiManager<MetricExporter> spiExportersManager = MetricExporterConfiguration.metricExporterSpiManager(config, spiHelper);
        MetricExporter metricExporter = MetricExporterConfiguration.configureExporter(name, spiExportersManager);
        if (metricExporter == null) {
            NamedSpiManager<MetricReader> spiMetricReadersManager = MetricExporterConfiguration.metricReadersSpiManager(config, spiHelper);
            MetricReader metricReader = MetricExporterConfiguration.configureMetricReader(name, spiMetricReadersManager);
            if (metricReader != null) {
                closeables.add(metricReader);
                MetricReader customizedMetricReader = metricReaderCustomizer.apply(metricReader, config);
                if (customizedMetricReader != metricReader) {
                    closeables.add(customizedMetricReader);
                }
                return customizedMetricReader;
            }
            throw new ConfigurationException("Unrecognized value for otel.metrics.exporter: " + name);
        }
        closeables.add(metricExporter);
        MetricExporter customizedMetricExporter = metricExporterCustomizer.apply(metricExporter, config);
        if (customizedMetricExporter != metricExporter) {
            closeables.add(customizedMetricExporter);
        }
        PeriodicMetricReader reader = PeriodicMetricReader.builder(customizedMetricExporter).setInterval(config.getDuration("otel.metric.export.interval", DEFAULT_EXPORT_INTERVAL)).build();
        closeables.add(reader);
        MetricReader customizedMetricReader = metricReaderCustomizer.apply(reader, config);
        if (customizedMetricReader != reader) {
            closeables.add(customizedMetricReader);
        }
        return customizedMetricReader;
    }

    static NamedSpiManager<MetricReader> metricReadersSpiManager(ConfigProperties config, SpiHelper spiHelper) {
        return spiHelper.loadConfigurable(ConfigurableMetricReaderProvider.class, ConfigurableMetricReaderProvider::getName, ConfigurableMetricReaderProvider::createMetricReader, config);
    }

    @Nullable
    static MetricReader configureMetricReader(String name, NamedSpiManager<MetricReader> spiMetricReadersManager) {
        MetricReader metricReader = spiMetricReadersManager.getByName(name);
        if (metricReader == null) {
            String artifactId = READER_ARTIFACT_ID_BY_NAME.get(name);
            if (artifactId != null) {
                throw MetricExporterConfiguration.missingArtifactException(name, artifactId);
            }
            return null;
        }
        return metricReader;
    }

    static NamedSpiManager<MetricExporter> metricExporterSpiManager(ConfigProperties config, SpiHelper spiHelper) {
        return spiHelper.loadConfigurable(ConfigurableMetricExporterProvider.class, ConfigurableMetricExporterProvider::getName, ConfigurableMetricExporterProvider::createExporter, config);
    }

    @Nullable
    static MetricExporter configureExporter(String name, NamedSpiManager<MetricExporter> spiExportersManager) {
        MetricExporter metricExporter = spiExportersManager.getByName(name);
        if (metricExporter == null) {
            String artifactId = EXPORTER_ARTIFACT_ID_BY_NAME.get(name);
            if (artifactId != null) {
                throw MetricExporterConfiguration.missingArtifactException(name, artifactId);
            }
            return null;
        }
        return metricExporter;
    }

    private static ConfigurationException missingArtifactException(String exporterName, String artifactId) {
        return new ConfigurationException("otel.metrics.exporter set to \"" + exporterName + "\" but " + artifactId + " not found on classpath. Make sure to add it as a dependency.");
    }

    private MetricExporterConfiguration() {
    }

    static {
        EXPORTER_ARTIFACT_ID_BY_NAME.put("console", "opentelemetry-exporter-logging");
        EXPORTER_ARTIFACT_ID_BY_NAME.put("logging", "opentelemetry-exporter-logging");
        EXPORTER_ARTIFACT_ID_BY_NAME.put("logging-otlp", "opentelemetry-exporter-logging-otlp");
        EXPORTER_ARTIFACT_ID_BY_NAME.put("otlp", "opentelemetry-exporter-otlp");
        READER_ARTIFACT_ID_BY_NAME = new HashMap<String, String>();
        READER_ARTIFACT_ID_BY_NAME.put("prometheus", "opentelemetry-exporter-prometheus");
    }
}

