/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.AttributesBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.ConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.ResourceProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.internal.ConditionalResourceProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.resources.Resource;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.resources.ResourceBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Logger;

public final class ResourceConfiguration {
    private static final Logger logger = Logger.getLogger(ResourceConfiguration.class.getName());
    private static final AttributeKey<String> SERVICE_NAME = AttributeKey.stringKey("service.name");
    static final String ATTRIBUTE_PROPERTY = "otel.resource.attributes";
    static final String SERVICE_NAME_PROPERTY = "otel.service.name";
    static final String EXPERIMENTAL_DISABLED_ATTRIBUTE_KEYS = "otel.experimental.resource.disabled.keys";
    static final String DISABLED_ATTRIBUTE_KEYS = "otel.resource.disabled.keys";

    public static Resource createEnvironmentResource() {
        return ResourceConfiguration.createEnvironmentResource(DefaultConfigProperties.create(Collections.emptyMap()));
    }

    public static Resource createEnvironmentResource(ConfigProperties config) {
        AttributesBuilder resourceAttributes = Attributes.builder();
        try {
            for (Map.Entry<String, String> entry : config.getMap(ATTRIBUTE_PROPERTY).entrySet()) {
                resourceAttributes.put(entry.getKey(), URLDecoder.decode(entry.getValue(), StandardCharsets.UTF_8.displayName()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigurationException("Unable to decode resource attributes.", e);
        }
        String serviceName = config.getString(SERVICE_NAME_PROPERTY);
        if (serviceName != null) {
            resourceAttributes.put(SERVICE_NAME, serviceName);
        }
        return Resource.create(resourceAttributes.build());
    }

    static Resource configureResource(ConfigProperties config, SpiHelper spiHelper, BiFunction<? super Resource, ConfigProperties, ? extends Resource> resourceCustomizer) {
        Resource result = Resource.getDefault();
        HashSet<String> enabledProviders = new HashSet<String>(config.getList("otel.java.enabled.resource.providers"));
        HashSet<String> disabledProviders = new HashSet<String>(config.getList("otel.java.disabled.resource.providers"));
        for (ResourceProvider resourceProvider : spiHelper.loadOrdered(ResourceProvider.class)) {
            if (!enabledProviders.isEmpty() && !enabledProviders.contains(resourceProvider.getClass().getName()) || disabledProviders.contains(resourceProvider.getClass().getName()) || resourceProvider instanceof ConditionalResourceProvider && !((ConditionalResourceProvider)resourceProvider).shouldApply(config, result)) continue;
            result = result.merge(resourceProvider.createResource(config));
        }
        result = ResourceConfiguration.filterAttributes(result, config);
        return resourceCustomizer.apply(result, config);
    }

    static Resource filterAttributes(Resource resource, ConfigProperties configProperties) {
        List<String> disabledAttibuteKeys = configProperties.getList(DISABLED_ATTRIBUTE_KEYS);
        if (disabledAttibuteKeys.isEmpty() && !(disabledAttibuteKeys = configProperties.getList(EXPERIMENTAL_DISABLED_ATTRIBUTE_KEYS)).isEmpty()) {
            logger.warning("otel.experimental.resource.disabled.keys is deprecated and will be removed after 1.45.0 release. Please use otel.resource.disabled.keys instead.");
        }
        HashSet<String> disabledKeys = new HashSet<String>(disabledAttibuteKeys);
        ResourceBuilder builder = resource.toBuilder().removeIf(attributeKey -> disabledKeys.contains(attributeKey.getKey()));
        if (resource.getSchemaUrl() != null) {
            builder.setSchemaUrl(resource.getSchemaUrl());
        }
        return builder.build();
    }

    private ResourceConfiguration() {
    }
}

