/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.internal.ComponentLoader;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.internal.NamedSpiManager;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.ConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.Ordered;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.internal.AutoConfigureListener;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.internal.StructuredConfigProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SpiHelper {
    private final ComponentLoader componentLoader;
    private final Set<AutoConfigureListener> listeners = Collections.newSetFromMap(new IdentityHashMap());

    private SpiHelper(ComponentLoader componentLoader) {
        this.componentLoader = componentLoader;
    }

    public static SpiHelper create(ClassLoader classLoader) {
        return new SpiHelper(SpiHelper.serviceComponentLoader(classLoader));
    }

    public static SpiHelper create(ComponentLoader componentLoader) {
        return new SpiHelper(componentLoader);
    }

    public static ComponentLoader serviceComponentLoader(ClassLoader classLoader) {
        return new ServiceLoaderComponentLoader(classLoader);
    }

    public ComponentLoader getComponentLoader() {
        return this.componentLoader;
    }

    public <T, S> NamedSpiManager<T> loadConfigurable(Class<S> spiClass, Function<S, String> getName, BiFunction<S, ConfigProperties, T> getConfigurable, ConfigProperties config) {
        HashMap nameToProvider = new HashMap();
        for (Object provider : this.load(spiClass)) {
            String name = getName.apply(provider);
            nameToProvider.put(name, () -> {
                Object result = getConfigurable.apply(provider, config);
                this.maybeAddListener(result);
                return result;
            });
        }
        return NamedSpiManager.create(nameToProvider);
    }

    public <T> T loadComponent(Class<T> type, String name, StructuredConfigProperties config) {
        List<ComponentProvider> componentProviders = this.load(ComponentProvider.class);
        List matchedProviders = componentProviders.stream().map(componentProvider -> componentProvider).filter(componentProvider -> componentProvider.getType() == type && name.equals(componentProvider.getName())).collect(Collectors.toList());
        if (matchedProviders.isEmpty()) {
            throw new ConfigurationException("No component provider detected for " + type.getName() + " with name \"" + name + "\".");
        }
        if (matchedProviders.size() > 1) {
            throw new ConfigurationException("Component provider conflict. Multiple providers detected for " + type.getName() + " with name \"" + name + "\": " + componentProviders.stream().map(provider -> provider.getClass().getName()).collect(Collectors.joining(",", "[", "]")));
        }
        ComponentProvider provider2 = (ComponentProvider)matchedProviders.get(0);
        try {
            return provider2.create(config);
        }
        catch (Throwable throwable) {
            throw new ConfigurationException("Error configuring " + type.getName() + " with name \"" + name + "\"", throwable);
        }
    }

    public <T extends Ordered> List<T> loadOrdered(Class<T> spiClass) {
        List<T> result = this.load(spiClass);
        result.sort(Comparator.comparing(Ordered::order));
        return result;
    }

    public <T> List<T> load(Class<T> spiClass) {
        ArrayList<T> result = new ArrayList<T>();
        for (T service : this.componentLoader.load(spiClass)) {
            this.maybeAddListener(service);
            result.add(service);
        }
        return result;
    }

    private void maybeAddListener(Object object) {
        if (object instanceof AutoConfigureListener) {
            this.listeners.add((AutoConfigureListener)object);
        }
    }

    public Set<AutoConfigureListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    private static class ServiceLoaderComponentLoader
    implements ComponentLoader {
        private final ClassLoader classLoader;

        private ServiceLoaderComponentLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public <T> Iterable<T> load(Class<T> spiClass) {
            return ServiceLoader.load(spiClass, this.classLoader);
        }
    }
}

