/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.extension.incubator.fileconfig.InstrumentSelectorFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.extension.incubator.fileconfig.MetricReaderFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.extension.incubator.fileconfig.ViewFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.extension.incubator.fileconfig.internal.model.MeterProviderModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.extension.incubator.fileconfig.internal.model.MetricReaderModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.extension.incubator.fileconfig.internal.model.SelectorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.extension.incubator.fileconfig.internal.model.StreamModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ViewModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.SdkMeterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.SdkMeterProviderBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.export.MetricReader;
import java.io.Closeable;
import java.util.List;

final class MeterProviderFactory
implements Factory<MeterProviderModel, SdkMeterProviderBuilder> {
    private static final MeterProviderFactory INSTANCE = new MeterProviderFactory();

    private MeterProviderFactory() {
    }

    static MeterProviderFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SdkMeterProviderBuilder create(MeterProviderModel model, SpiHelper spiHelper, List<Closeable> closeables) {
        List<ViewModel> viewModels;
        SdkMeterProviderBuilder builder = SdkMeterProvider.builder();
        List<MetricReaderModel> readerModels = model.getReaders();
        if (readerModels != null) {
            readerModels.forEach(readerModel -> {
                MetricReader metricReader = MetricReaderFactory.getInstance().create((MetricReaderModel)readerModel, spiHelper, closeables);
                if (metricReader != null) {
                    builder.registerMetricReader(metricReader);
                }
            });
        }
        if ((viewModels = model.getViews()) != null) {
            viewModels.forEach(viewModel -> {
                SelectorModel selector = FileConfigUtil.requireNonNull(viewModel.getSelector(), "view selector");
                StreamModel stream = FileConfigUtil.requireNonNull(viewModel.getStream(), "view stream");
                builder.registerView(InstrumentSelectorFactory.getInstance().create(selector, spiHelper, closeables), ViewFactory.getInstance().create(stream, spiHelper, closeables));
            });
        }
        return builder;
    }
}

