/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.internal.ComponentLoader;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.autoconfigure.spi.internal.StructuredConfigProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class YamlStructuredConfigProperties
implements StructuredConfigProperties {
    private final Map<String, Object> simpleEntries;
    private final Map<String, List<YamlStructuredConfigProperties>> listEntries;
    private final Map<String, YamlStructuredConfigProperties> mapEntries;
    private final ComponentLoader componentLoader;
    private static final Set<Class<?>> SUPPORTED_SCALAR_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(String.class, Boolean.class, Long.class, Double.class)));

    private YamlStructuredConfigProperties(Map<String, Object> simpleEntries, Map<String, List<YamlStructuredConfigProperties>> listEntries, Map<String, YamlStructuredConfigProperties> mapEntries, ComponentLoader componentLoader) {
        this.simpleEntries = simpleEntries;
        this.listEntries = listEntries;
        this.mapEntries = mapEntries;
        this.componentLoader = componentLoader;
    }

    static YamlStructuredConfigProperties create(Map<String, Object> properties, ComponentLoader componentLoader) {
        HashMap<String, Object> simpleEntries = new HashMap<String, Object>();
        HashMap<String, List<YamlStructuredConfigProperties>> listEntries = new HashMap<String, List<YamlStructuredConfigProperties>>();
        HashMap<String, YamlStructuredConfigProperties> mapEntries = new HashMap<String, YamlStructuredConfigProperties>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (YamlStructuredConfigProperties.isPrimitive(value) || value == null) {
                simpleEntries.put(key, value);
                continue;
            }
            if (YamlStructuredConfigProperties.isPrimitiveList(value)) {
                simpleEntries.put(key, value);
                continue;
            }
            if (YamlStructuredConfigProperties.isListOfMaps(value)) {
                List list = ((List)value).stream().map(map -> YamlStructuredConfigProperties.create(map, componentLoader)).collect(Collectors.toList());
                listEntries.put(key, list);
                continue;
            }
            if (YamlStructuredConfigProperties.isMap(value)) {
                YamlStructuredConfigProperties configProperties = YamlStructuredConfigProperties.create((Map)value, componentLoader);
                mapEntries.put(key, configProperties);
                continue;
            }
            throw new ConfigurationException("Unable to initialize ExtendedConfigProperties. Key \"" + key + "\" has unrecognized object type " + value.getClass().getName());
        }
        return new YamlStructuredConfigProperties(simpleEntries, listEntries, mapEntries, componentLoader);
    }

    private static boolean isPrimitiveList(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return list.stream().allMatch(YamlStructuredConfigProperties::isPrimitive);
        }
        return false;
    }

    private static boolean isPrimitive(Object object) {
        return object instanceof String || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Boolean;
    }

    private static boolean isListOfMaps(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return list.stream().allMatch(entry -> entry instanceof Map && ((Map)entry).keySet().stream().allMatch(key -> key instanceof String));
        }
        return false;
    }

    private static boolean isMap(Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            return map.keySet().stream().allMatch(entry -> entry instanceof String);
        }
        return false;
    }

    @Override
    @Nullable
    public String getString(String name) {
        return YamlStructuredConfigProperties.stringOrNull(this.simpleEntries.get(name));
    }

    @Override
    @Nullable
    public Boolean getBoolean(String name) {
        return YamlStructuredConfigProperties.booleanOrNull(this.simpleEntries.get(name));
    }

    @Override
    @Nullable
    public Integer getInt(String name) {
        Object value = this.simpleEntries.get(name);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return null;
    }

    @Override
    @Nullable
    public Long getLong(String name) {
        return YamlStructuredConfigProperties.longOrNull(this.simpleEntries.get(name));
    }

    @Override
    @Nullable
    public Double getDouble(String name) {
        return YamlStructuredConfigProperties.doubleOrNull(this.simpleEntries.get(name));
    }

    @Override
    @Nullable
    public <T> List<T> getScalarList(String name, Class<T> scalarType) {
        if (!SUPPORTED_SCALAR_TYPES.contains(scalarType)) {
            throw new ConfigurationException("Unsupported scalar type " + scalarType.getName() + ". Supported types include " + SUPPORTED_SCALAR_TYPES.stream().map(Class::getName).collect(Collectors.joining(",", "[", "]")));
        }
        Object value = this.simpleEntries.get(name);
        if (value instanceof List) {
            return ((List)value).stream().map(entry -> {
                if (scalarType == String.class) {
                    return YamlStructuredConfigProperties.stringOrNull(entry);
                }
                if (scalarType == Boolean.class) {
                    return YamlStructuredConfigProperties.booleanOrNull(entry);
                }
                if (scalarType == Long.class) {
                    return YamlStructuredConfigProperties.longOrNull(entry);
                }
                if (scalarType == Double.class) {
                    return YamlStructuredConfigProperties.doubleOrNull(entry);
                }
                return null;
            }).filter(x$0 -> Objects.nonNull(x$0)).collect(Collectors.toList());
        }
        return null;
    }

    @Nullable
    private static String stringOrNull(@Nullable Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Nullable
    private static Boolean booleanOrNull(@Nullable Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }

    @Nullable
    private static Long longOrNull(@Nullable Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return null;
    }

    @Nullable
    private static Double doubleOrNull(@Nullable Object value) {
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return null;
    }

    @Override
    @Nullable
    public StructuredConfigProperties getStructured(String name) {
        return this.mapEntries.get(name);
    }

    @Override
    @Nullable
    public List<StructuredConfigProperties> getStructuredList(String name) {
        List<YamlStructuredConfigProperties> value = this.listEntries.get(name);
        if (value != null) {
            return Collections.unmodifiableList(value);
        }
        return null;
    }

    @Override
    public Set<String> getPropertyKeys() {
        HashSet<String> keys2 = new HashSet<String>();
        keys2.addAll(this.simpleEntries.keySet());
        keys2.addAll(this.listEntries.keySet());
        keys2.addAll(this.mapEntries.keySet());
        return Collections.unmodifiableSet(keys2);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "YamlStructuredConfigProperties{", "}");
        this.simpleEntries.forEach((key, value) -> joiner.add(key + "=" + value));
        this.listEntries.forEach((key, value) -> joiner.add(key + "=" + value));
        this.mapEntries.forEach((key, value) -> joiner.add(key + "=" + value));
        return joiner.toString();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.simpleEntries);
        this.listEntries.forEach((key, value) -> result.put((String)key, value.stream().map(YamlStructuredConfigProperties::toMap).collect(Collectors.toList())));
        this.mapEntries.forEach((key, value) -> result.put((String)key, value.toMap()));
        return Collections.unmodifiableMap(result);
    }

    public ComponentLoader getComponentLoader() {
        return this.componentLoader;
    }
}

