/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.logs;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.internal.Utils;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.logs.LogLimits;

public final class LogLimitsBuilder {
    private static final int DEFAULT_LOG_MAX_NUM_ATTRIBUTES = 128;
    private static final int DEFAULT_LOG_MAX_ATTRIBUTE_LENGTH = Integer.MAX_VALUE;
    private int maxNumAttributes = 128;
    private int maxAttributeValueLength = Integer.MAX_VALUE;

    LogLimitsBuilder() {
    }

    public LogLimitsBuilder setMaxNumberOfAttributes(int maxNumberOfAttributes) {
        Utils.checkArgument(maxNumberOfAttributes > 0, "maxNumberOfAttributes must be greater than 0");
        this.maxNumAttributes = maxNumberOfAttributes;
        return this;
    }

    public LogLimitsBuilder setMaxAttributeValueLength(int maxAttributeValueLength) {
        Utils.checkArgument(maxAttributeValueLength > -1, "maxAttributeValueLength must be non-negative");
        this.maxAttributeValueLength = maxAttributeValueLength;
        return this;
    }

    public LogLimits build() {
        return LogLimits.create(this.maxNumAttributes, this.maxAttributeValueLength);
    }
}

