/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.logs.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.Value;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.incubator.events.EventBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.incubator.logs.ExtendedLogRecordBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.logs.LogRecordBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.logs.Severity;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.common.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class SdkEventBuilder
implements EventBuilder {
    private static final AttributeKey<String> EVENT_NAME = AttributeKey.stringKey("event.name");
    private final Map<String, Value<?>> payload = new HashMap();
    private final Clock clock;
    private final LogRecordBuilder logRecordBuilder;
    private final String eventName;
    private boolean hasTimestamp = false;

    SdkEventBuilder(Clock clock, LogRecordBuilder logRecordBuilder, String eventName) {
        this.clock = clock;
        this.logRecordBuilder = logRecordBuilder;
        this.eventName = eventName;
    }

    @Override
    public EventBuilder put(String key, Value<?> value) {
        this.payload.put(key, value);
        return this;
    }

    @Override
    public EventBuilder setTimestamp(long timestamp, TimeUnit unit) {
        this.logRecordBuilder.setTimestamp(timestamp, unit);
        this.hasTimestamp = true;
        return this;
    }

    @Override
    public EventBuilder setTimestamp(Instant instant) {
        this.logRecordBuilder.setTimestamp(instant);
        this.hasTimestamp = true;
        return this;
    }

    @Override
    public EventBuilder setContext(Context context) {
        this.logRecordBuilder.setContext(context);
        return this;
    }

    @Override
    public EventBuilder setSeverity(Severity severity) {
        this.logRecordBuilder.setSeverity(severity);
        return this;
    }

    @Override
    public EventBuilder setAttributes(Attributes attributes) {
        this.logRecordBuilder.setAllAttributes(attributes);
        return this;
    }

    @Override
    public void emit() {
        if (!this.payload.isEmpty()) {
            ((ExtendedLogRecordBuilder)this.logRecordBuilder).setBody(Value.of(this.payload));
        }
        if (!this.hasTimestamp) {
            this.logRecordBuilder.setTimestamp(this.clock.now(), TimeUnit.NANOSECONDS);
        }
        this.logRecordBuilder.setAttribute(EVENT_NAME, this.eventName);
        this.logRecordBuilder.emit();
    }
}

