/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.logs.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.incubator.events.EventBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.incubator.events.EventLogger;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.incubator.events.EventLoggerBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.incubator.events.EventLoggerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.logs.Logger;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.logs.LoggerBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.logs.LoggerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.logs.Severity;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.common.Clock;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.logs.internal.SdkEventBuilder;

public final class SdkEventLoggerProvider
implements EventLoggerProvider {
    private static final Severity DEFAULT_SEVERITY = Severity.INFO;
    private final LoggerProvider delegateLoggerProvider;
    private final Clock clock;

    private SdkEventLoggerProvider(LoggerProvider delegateLoggerProvider, Clock clock) {
        this.delegateLoggerProvider = delegateLoggerProvider;
        this.clock = clock;
    }

    public static SdkEventLoggerProvider create(LoggerProvider delegateLoggerProvider) {
        return new SdkEventLoggerProvider(delegateLoggerProvider, Clock.getDefault());
    }

    public static SdkEventLoggerProvider create(LoggerProvider delegateLoggerProvider, Clock clock) {
        return new SdkEventLoggerProvider(delegateLoggerProvider, clock);
    }

    @Override
    public EventLogger get(String instrumentationScopeName) {
        return this.eventLoggerBuilder(instrumentationScopeName).build();
    }

    @Override
    public EventLoggerBuilder eventLoggerBuilder(String instrumentationScopeName) {
        return new SdkEventLoggerBuilder(this.clock, this.delegateLoggerProvider.loggerBuilder(instrumentationScopeName));
    }

    private static class SdkEventLoggerBuilder
    implements EventLoggerBuilder {
        private final Clock clock;
        private final LoggerBuilder delegateLoggerBuilder;

        private SdkEventLoggerBuilder(Clock clock, LoggerBuilder delegateLoggerBuilder) {
            this.clock = clock;
            this.delegateLoggerBuilder = delegateLoggerBuilder;
        }

        @Override
        public EventLoggerBuilder setSchemaUrl(String schemaUrl) {
            this.delegateLoggerBuilder.setSchemaUrl(schemaUrl);
            return this;
        }

        @Override
        public EventLoggerBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
            this.delegateLoggerBuilder.setInstrumentationVersion(instrumentationScopeVersion);
            return this;
        }

        @Override
        public EventLogger build() {
            return new SdkEventLogger(this.clock, this.delegateLoggerBuilder.build());
        }
    }

    private static class SdkEventLogger
    implements EventLogger {
        private final Clock clock;
        private final Logger delegateLogger;

        private SdkEventLogger(Clock clock, Logger delegateLogger) {
            this.clock = clock;
            this.delegateLogger = delegateLogger;
        }

        @Override
        public EventBuilder builder(String eventName) {
            return new SdkEventBuilder(this.clock, this.delegateLogger.logRecordBuilder().setSeverity(DEFAULT_SEVERITY).setContext(Context.current()), eventName);
        }
    }
}

