/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.incubator.metrics.ExtendedDoubleGauge;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.incubator.metrics.ExtendedDoubleGaugeBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.metrics.DoubleGaugeBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.metrics.LongGaugeBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.metrics.ObservableDoubleGauge;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.metrics.ObservableDoubleMeasurement;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.AbstractInstrument;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.InstrumentBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.InstrumentValueType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.SdkLongGauge;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.SdkMeter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.function.Consumer;

final class SdkDoubleGauge
extends AbstractInstrument
implements ExtendedDoubleGauge {
    private final SdkMeter sdkMeter;
    private final WriteableMetricStorage storage;

    private SdkDoubleGauge(InstrumentDescriptor descriptor, SdkMeter sdkMeter, WriteableMetricStorage storage) {
        super(descriptor);
        this.sdkMeter = sdkMeter;
        this.storage = storage;
    }

    @Override
    public void set(double value, Attributes attributes) {
        this.storage.recordDouble(value, attributes, Context.current());
    }

    @Override
    public void set(double value, Attributes attributes, Context context) {
        this.storage.recordDouble(value, attributes, context);
    }

    @Override
    public void set(double increment) {
        this.set(increment, Attributes.empty());
    }

    @Override
    public boolean isEnabled() {
        return this.sdkMeter.isMeterEnabled() && this.storage.isEnabled();
    }

    static final class SdkDoubleGaugeBuilder
    implements ExtendedDoubleGaugeBuilder {
        private final InstrumentBuilder builder;

        SdkDoubleGaugeBuilder(SdkMeter sdkMeter, String name) {
            this.builder = new InstrumentBuilder(name, InstrumentType.GAUGE, InstrumentValueType.DOUBLE, sdkMeter);
        }

        @Override
        public DoubleGaugeBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public DoubleGaugeBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkDoubleGauge build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1, x$2) -> new SdkDoubleGauge(x$0, x$1, x$2));
        }

        @Override
        public ExtendedDoubleGaugeBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.builder.setAdviceAttributes(attributes);
            return this;
        }

        @Override
        public LongGaugeBuilder ofLongs() {
            return this.builder.swapBuilder(SdkLongGauge.SdkLongGaugeBuilder::new);
        }

        @Override
        public ObservableDoubleGauge buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return this.builder.buildDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_GAUGE, callback);
        }

        @Override
        public ObservableDoubleMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_GAUGE);
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

