/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.incubator.metrics.ExtendedDoubleUpDownCounter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.incubator.metrics.ExtendedDoubleUpDownCounterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.metrics.DoubleUpDownCounter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.metrics.DoubleUpDownCounterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.metrics.ObservableDoubleMeasurement;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.metrics.ObservableDoubleUpDownCounter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.AbstractInstrument;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.InstrumentBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.InstrumentValueType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.SdkMeter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.internal.descriptor.Advice;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.function.Consumer;

final class SdkDoubleUpDownCounter
extends AbstractInstrument
implements ExtendedDoubleUpDownCounter {
    private final SdkMeter sdkMeter;
    private final WriteableMetricStorage storage;

    private SdkDoubleUpDownCounter(InstrumentDescriptor descriptor, SdkMeter sdkMeter, WriteableMetricStorage storage) {
        super(descriptor);
        this.sdkMeter = sdkMeter;
        this.storage = storage;
    }

    @Override
    public void add(double increment, Attributes attributes, Context context) {
        this.storage.recordDouble(increment, attributes, context);
    }

    @Override
    public void add(double increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    @Override
    public void add(double increment) {
        this.add(increment, Attributes.empty());
    }

    @Override
    public boolean isEnabled() {
        return this.sdkMeter.isMeterEnabled() && this.storage.isEnabled();
    }

    static final class SdkDoubleUpDownCounterBuilder
    implements ExtendedDoubleUpDownCounterBuilder {
        private final InstrumentBuilder builder;

        SdkDoubleUpDownCounterBuilder(SdkMeter sdkMeter, String name, String description, String unit, Advice.AdviceBuilder adviceBuilder) {
            this.builder = new InstrumentBuilder(name, InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.DOUBLE, sdkMeter).setDescription(description).setUnit(unit).setAdviceBuilder(adviceBuilder);
        }

        @Override
        public DoubleUpDownCounterBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public DoubleUpDownCounterBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public DoubleUpDownCounter build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1, x$2) -> new SdkDoubleUpDownCounter(x$0, x$1, x$2));
        }

        @Override
        public ObservableDoubleUpDownCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return this.builder.buildDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, callback);
        }

        @Override
        public ObservableDoubleMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER);
        }

        @Override
        public ExtendedDoubleUpDownCounterBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.builder.setAdviceAttributes(attributes);
            return this;
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

