/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.internal.exemplar;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.data.ExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.internal.exemplar.ExemplarReservoir;
import java.util.List;

class FilteredExemplarReservoir<T extends ExemplarData>
implements ExemplarReservoir<T> {
    private final ExemplarFilter filter;
    private final ExemplarReservoir<T> reservoir;

    FilteredExemplarReservoir(ExemplarFilter filter, ExemplarReservoir<T> reservoir) {
        this.filter = filter;
        this.reservoir = reservoir;
    }

    @Override
    public void offerDoubleMeasurement(double value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerDoubleMeasurement(value, attributes, context);
        }
    }

    @Override
    public void offerLongMeasurement(long value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerLongMeasurement(value, attributes, context);
        }
    }

    @Override
    public List<T> collectAndReset(Attributes pointAttributes) {
        return this.reservoir.collectAndReset(pointAttributes);
    }
}

