/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.internal.exemplar;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.common.Clock;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.data.DoubleExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.internal.exemplar.FixedSizeExemplarReservoir;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.internal.exemplar.ReservoirCell;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.metrics.internal.exemplar.ReservoirCellSelector;
import java.util.List;

class HistogramExemplarReservoir
extends FixedSizeExemplarReservoir<DoubleExemplarData> {
    HistogramExemplarReservoir(Clock clock, List<Double> boundaries) {
        super(clock, boundaries.size() + 1, new HistogramCellSelector(boundaries), ReservoirCell::getAndResetDouble);
    }

    @Override
    public void offerLongMeasurement(long value, Attributes attributes, Context context) {
        super.offerDoubleMeasurement(value, attributes, context);
    }

    static class HistogramCellSelector
    implements ReservoirCellSelector {
        private final double[] boundaries;

        private HistogramCellSelector(List<Double> boundaries) {
            this.boundaries = ExplicitBucketHistogramUtils.createBoundaryArray(boundaries);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] cells, long value, Attributes attributes, Context context) {
            return this.reservoirCellIndexFor(cells, (double)value, attributes, context);
        }

        @Override
        public int reservoirCellIndexFor(ReservoirCell[] cells, double value, Attributes attributes, Context context) {
            return ExplicitBucketHistogramUtils.findBucketIndex(this.boundaries, value);
        }

        @Override
        public void reset() {
        }
    }
}

