/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.trace;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.trace.Tracer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.trace.TracerBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.api.trace.TracerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.common.Clock;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.internal.ComponentRegistry;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.internal.ScopeConfigurator;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.resources.Resource;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.trace.IdGenerator;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.trace.SdkTracer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.trace.SdkTracerBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.trace.SdkTracerProviderBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.trace.SpanLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.trace.SpanProcessor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.trace.TracerSharedState;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.trace.internal.TracerConfig;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.trace.samplers.Sampler;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SdkTracerProvider
implements TracerProvider,
Closeable {
    private static final Logger logger = Logger.getLogger(SdkTracerProvider.class.getName());
    static final String DEFAULT_TRACER_NAME = "";
    private final TracerSharedState sharedState;
    private final ComponentRegistry<SdkTracer> tracerSdkComponentRegistry;
    private final ScopeConfigurator<TracerConfig> tracerConfigurator;

    public static SdkTracerProviderBuilder builder() {
        return new SdkTracerProviderBuilder();
    }

    SdkTracerProvider(Clock clock, IdGenerator idsGenerator, Resource resource, Supplier<SpanLimits> spanLimitsSupplier, Sampler sampler, List<SpanProcessor> spanProcessors, ScopeConfigurator<TracerConfig> tracerConfigurator) {
        this.sharedState = new TracerSharedState(clock, idsGenerator, resource, spanLimitsSupplier, sampler, spanProcessors);
        this.tracerSdkComponentRegistry = new ComponentRegistry<SdkTracer>(instrumentationScopeInfo -> new SdkTracer(this.sharedState, (InstrumentationScopeInfo)instrumentationScopeInfo, this.getTracerConfig((InstrumentationScopeInfo)instrumentationScopeInfo)));
        this.tracerConfigurator = tracerConfigurator;
    }

    private TracerConfig getTracerConfig(InstrumentationScopeInfo instrumentationScopeInfo) {
        TracerConfig tracerConfig = (TracerConfig)this.tracerConfigurator.apply((TracerConfig)((Object)instrumentationScopeInfo));
        return tracerConfig == null ? TracerConfig.defaultConfig() : tracerConfig;
    }

    @Override
    public Tracer get(String instrumentationScopeName) {
        return this.tracerBuilder(instrumentationScopeName).build();
    }

    @Override
    public Tracer get(String instrumentationScopeName, String instrumentationScopeVersion) {
        return this.tracerBuilder(instrumentationScopeName).setInstrumentationVersion(instrumentationScopeVersion).build();
    }

    @Override
    public TracerBuilder tracerBuilder(@Nullable String instrumentationScopeName) {
        if (instrumentationScopeName == null || instrumentationScopeName.isEmpty()) {
            logger.fine("Tracer requested without instrumentation scope name.");
            instrumentationScopeName = DEFAULT_TRACER_NAME;
        }
        return new SdkTracerBuilder(this.tracerSdkComponentRegistry, instrumentationScopeName);
    }

    public SpanLimits getSpanLimits() {
        return this.sharedState.getSpanLimits();
    }

    public Sampler getSampler() {
        return this.sharedState.getSampler();
    }

    public CompletableResultCode shutdown() {
        if (this.sharedState.hasBeenShutdown()) {
            logger.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    public CompletableResultCode forceFlush() {
        return this.sharedState.getActiveSpanProcessor().forceFlush();
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "SdkTracerProvider{clock=" + this.sharedState.getClock() + ", idGenerator=" + this.sharedState.getIdGenerator() + ", resource=" + this.sharedState.getResource() + ", spanLimitsSupplier=" + this.sharedState.getSpanLimits() + ", sampler=" + this.sharedState.getSampler() + ", spanProcessor=" + this.sharedState.getActiveSpanProcessor() + '}';
    }
}

