/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.sdk.trace.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.internal.shaded.jctools.queues.MessagePassingQueue;
import io.prometheus.metrics.shaded.io_opentelemetry_2_10_0_alpha.internal.shaded.jctools.queues.MpscArrayQueue;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JcTools {
    private static final AtomicBoolean queueCreationWarningLogged = new AtomicBoolean();
    private static final Logger logger = Logger.getLogger(JcTools.class.getName());

    public static <T> Queue<T> newFixedSizeQueue(int capacity) {
        try {
            return new MpscArrayQueue(capacity);
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError e) {
            if (!queueCreationWarningLogged.getAndSet(true)) {
                logger.log(Level.WARNING, "Cannot create high-performance queue, reverting to ArrayBlockingQueue ({0})", Objects.toString(e, "unknown cause"));
            }
            return new ArrayBlockingQueue(capacity);
        }
    }

    public static long capacity(Queue<?> queue) {
        if (queue instanceof MessagePassingQueue) {
            return ((MessagePassingQueue)((Object)queue)).capacity();
        }
        return (long)((ArrayBlockingQueue)queue).remainingCapacity() + (long)queue.size();
    }

    public static <T> void drain(Queue<T> queue, int limit, Consumer<T> consumer) {
        if (queue instanceof MessagePassingQueue) {
            ((MessagePassingQueue)((Object)queue)).drain(consumer::accept, limit);
        } else {
            JcTools.drainNonJcQueue(queue, limit, consumer);
        }
    }

    private static <T> void drainNonJcQueue(Queue<T> queue, int maxExportBatchSize, Consumer<T> consumer) {
        T item;
        int polledCount = 0;
        while (polledCount++ < maxExportBatchSize && (item = queue.poll()) != null) {
            consumer.accept(item);
        }
    }

    private JcTools() {
    }
}

