/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.otlp.traces;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.ProtoFieldInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.exporter.internal.otlp.KeyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.proto.trace.v1.internal.Span;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.data.EventData;
import java.io.IOException;
import java.util.List;

final class SpanEventMarshaler
extends MarshalerWithSize {
    private static final SpanEventMarshaler[] EMPTY = new SpanEventMarshaler[0];
    private final long epochNanos;
    private final byte[] name;
    private final KeyValueMarshaler[] attributeMarshalers;
    private final int droppedAttributesCount;

    static SpanEventMarshaler[] createRepeated(List<EventData> events) {
        if (events.isEmpty()) {
            return EMPTY;
        }
        SpanEventMarshaler[] result = new SpanEventMarshaler[events.size()];
        int pos = 0;
        for (EventData event : events) {
            result[pos++] = SpanEventMarshaler.create(event);
        }
        return result;
    }

    static SpanEventMarshaler create(EventData event) {
        return new SpanEventMarshaler(event.getEpochNanos(), MarshalerUtil.toBytes(event.getName()), KeyValueMarshaler.createForAttributes(event.getAttributes()), event.getTotalAttributeCount() - event.getAttributes().size());
    }

    private SpanEventMarshaler(long epochNanos, byte[] name, KeyValueMarshaler[] attributeMarshalers, int droppedAttributesCount) {
        super(SpanEventMarshaler.calculateSize(epochNanos, name, attributeMarshalers, droppedAttributesCount));
        this.epochNanos = epochNanos;
        this.name = name;
        this.attributeMarshalers = attributeMarshalers;
        this.droppedAttributesCount = droppedAttributesCount;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeFixed64(Span.Event.TIME_UNIX_NANO, this.epochNanos);
        output.serializeString(Span.Event.NAME, this.name);
        output.serializeRepeatedMessage(Span.Event.ATTRIBUTES, this.attributeMarshalers);
        output.serializeUInt32(Span.Event.DROPPED_ATTRIBUTES_COUNT, this.droppedAttributesCount);
    }

    private static int calculateSize(long epochNanos, byte[] name, KeyValueMarshaler[] attributeMarshalers, int droppedAttributesCount) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64(Span.Event.TIME_UNIX_NANO, epochNanos);
        size += MarshalerUtil.sizeBytes(Span.Event.NAME, name);
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Span.Event.ATTRIBUTES, (Marshaler[])attributeMarshalers);
        return size += MarshalerUtil.sizeUInt32(Span.Event.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
    }
}

