/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.api.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class EmbeddedInstrumentationProperties {
    private static final Logger logger = Logger.getLogger(EmbeddedInstrumentationProperties.class.getName());
    private static final ClassLoader DEFAULT_LOADER;
    private static volatile ClassLoader loader;
    private static final Map<String, String> versions;

    public static void setPropertiesLoader(ClassLoader propertiesLoader) {
        if (loader != DEFAULT_LOADER) {
            logger.warning("Embedded properties loader has already been set up, further setPropertiesLoader() calls are ignored");
            return;
        }
        loader = propertiesLoader;
    }

    @Nullable
    public static String findVersion(String instrumentationName) {
        return versions.computeIfAbsent(instrumentationName, EmbeddedInstrumentationProperties::loadVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String loadVersion(String instrumentationName) {
        String path = "META-INF/io/opentelemetry/instrumentation/" + instrumentationName + ".properties";
        try (InputStream in = loader.getResourceAsStream(path);){
            if (in == null) {
                logger.log(Level.FINE, "Did not find embedded instrumentation properties file {0}", path);
                String string2 = null;
                return string2;
            }
            Properties parsed = new Properties();
            parsed.load(in);
            String string = parsed.getProperty("version");
            return string;
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Failed to load embedded instrumentation properties file " + path, e);
            return null;
        }
    }

    private EmbeddedInstrumentationProperties() {
    }

    static {
        ClassLoader defaultLoader = EmbeddedInstrumentationProperties.class.getClassLoader();
        if (defaultLoader == null) {
            defaultLoader = new BootstrapProxy();
        }
        loader = DEFAULT_LOADER = defaultLoader;
        versions = new ConcurrentHashMap<String, String>();
    }

    private static final class BootstrapProxy
    extends ClassLoader {
        BootstrapProxy() {
            super(null);
        }
    }
}

