/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.resources;

import com.google.auto.service.AutoService;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.resources.MainJarPathFinder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.resources.MainJarPathHolder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.spi.ConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.spi.ResourceProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.spi.internal.ConditionalResourceProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.resources.Resource;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.semconv.ServiceAttributes;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

@AutoService(value={ResourceProvider.class})
public final class JarServiceNameDetector
implements ConditionalResourceProvider {
    private static final Logger logger = Logger.getLogger(JarServiceNameDetector.class.getName());
    private final Supplier<Optional<Path>> jarPathSupplier;

    public JarServiceNameDetector() {
        this(MainJarPathHolder::getJarPath);
    }

    private JarServiceNameDetector(Supplier<Optional<Path>> jarPathSupplier) {
        this.jarPathSupplier = jarPathSupplier;
    }

    JarServiceNameDetector(MainJarPathFinder jarPathFinder) {
        this(() -> Optional.ofNullable(jarPathFinder.detectJarPath()));
    }

    @Override
    public Resource createResource(ConfigProperties config) {
        return this.jarPathSupplier.get().map(jarPath -> {
            String serviceName = JarServiceNameDetector.getServiceName(jarPath);
            logger.log(Level.FINE, "Auto-detected service name from the jar file name: {0}", serviceName);
            return Resource.create(Attributes.of(ServiceAttributes.SERVICE_NAME, serviceName));
        }).orElseGet(Resource::empty);
    }

    @Override
    public boolean shouldApply(ConfigProperties config, Resource existing) {
        String serviceName = config.getString("otel.service.name");
        Map<String, String> resourceAttributes = config.getMap("otel.resource.attributes");
        return serviceName == null && !resourceAttributes.containsKey(ServiceAttributes.SERVICE_NAME.getKey()) && "unknown_service:java".equals(existing.getAttribute(ServiceAttributes.SERVICE_NAME));
    }

    private static String getServiceName(Path jarPath) {
        String jarName = jarPath.getFileName().toString();
        int dotIndex = jarName.lastIndexOf(".");
        return dotIndex == -1 ? jarName : jarName.substring(0, dotIndex);
    }

    @Override
    public int order() {
        return 1000;
    }
}

