/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.resources;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.AttributesBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.resources.ProcessArguments;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.instrumentation.resources.ProcessPid;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.resources.Resource;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public final class ProcessResource {
    private static final AttributeKey<List<String>> PROCESS_COMMAND_ARGS = AttributeKey.stringArrayKey("process.command_args");
    private static final AttributeKey<String> PROCESS_COMMAND_LINE = AttributeKey.stringKey("process.command_line");
    private static final AttributeKey<String> PROCESS_EXECUTABLE_PATH = AttributeKey.stringKey("process.executable.path");
    private static final AttributeKey<Long> PROCESS_PID = AttributeKey.longKey("process.pid");
    private static final Pattern JAR_FILE_PATTERN = Pattern.compile("^\\S+\\.(jar|war)", 2);
    private static final Resource INSTANCE = ProcessResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    static Resource buildResource() {
        try {
            return ProcessResource.doBuildResource();
        }
        catch (LinkageError t) {
            return Resource.empty();
        }
    }

    private static Resource doBuildResource() {
        AttributesBuilder attributes = Attributes.builder();
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        long pid = ProcessPid.getPid();
        if (pid >= 0L) {
            attributes.put(PROCESS_PID, Long.valueOf(pid));
        }
        String javaHome = null;
        String osName = null;
        try {
            javaHome = System.getProperty("java.home");
            osName = System.getProperty("os.name");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (javaHome != null) {
            StringBuilder executablePath = new StringBuilder(javaHome);
            executablePath.append(File.separatorChar).append("bin").append(File.separatorChar).append("java");
            if (osName != null && osName.toLowerCase(Locale.ROOT).startsWith("windows")) {
                executablePath.append(".exe");
            }
            attributes.put(PROCESS_EXECUTABLE_PATH, executablePath.toString());
            String[] args2 = ProcessArguments.getProcessArguments();
            if (args2.length > 0) {
                ArrayList<String> commandArgs = new ArrayList<String>(args2.length + 1);
                commandArgs.add(executablePath.toString());
                commandArgs.addAll(Arrays.asList(args2));
                attributes.put(PROCESS_COMMAND_ARGS, commandArgs);
            } else {
                StringBuilder commandLine = new StringBuilder(executablePath);
                for (String arg : runtime.getInputArguments()) {
                    commandLine.append(' ').append(arg);
                }
                String javaCommand = System.getProperty("sun.java.command");
                if (javaCommand != null) {
                    if (JAR_FILE_PATTERN.matcher(javaCommand).matches()) {
                        commandLine.append(" -jar");
                    }
                    commandLine.append(' ').append(javaCommand);
                }
                attributes.put(PROCESS_COMMAND_LINE, commandLine.toString());
            }
        }
        return Resource.create(attributes.build(), "https://opentelemetry.io/schemas/1.24.0");
    }

    private ProcessResource() {
    }
}

