/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.MetricExporterFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.MetricReaderModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.PeriodicMetricReaderModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.PrometheusModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.PullMetricExporterModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.PullMetricReaderModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.PushMetricExporterModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.export.MetricExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.export.MetricReader;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.export.PeriodicMetricReader;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.export.PeriodicMetricReaderBuilder;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;

final class MetricReaderFactory
implements Factory<MetricReaderModel, MetricReader> {
    private static final MetricReaderFactory INSTANCE = new MetricReaderFactory();

    private MetricReaderFactory() {
    }

    static MetricReaderFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public MetricReader create(MetricReaderModel model, SpiHelper spiHelper, List<Closeable> closeables) {
        PeriodicMetricReaderModel periodicModel = model.getPeriodic();
        if (periodicModel != null) {
            PushMetricExporterModel exporterModel = FileConfigUtil.requireNonNull(periodicModel.getExporter(), "periodic metric reader exporter");
            MetricExporter metricExporter = MetricExporterFactory.getInstance().create(exporterModel, spiHelper, closeables);
            PeriodicMetricReaderBuilder builder = PeriodicMetricReader.builder(FileConfigUtil.addAndReturn(closeables, metricExporter));
            if (periodicModel.getInterval() != null) {
                builder.setInterval(Duration.ofMillis(periodicModel.getInterval().intValue()));
            }
            return FileConfigUtil.addAndReturn(closeables, builder.build());
        }
        PullMetricReaderModel pullModel = model.getPull();
        if (pullModel != null) {
            PullMetricExporterModel exporterModel = FileConfigUtil.requireNonNull(pullModel.getExporter(), "pull metric reader exporter");
            PrometheusModel prometheusModel = exporterModel.getPrometheus();
            if (prometheusModel != null) {
                MetricReader metricReader = FileConfigUtil.loadComponent(spiHelper, MetricReader.class, "prometheus", prometheusModel);
                return FileConfigUtil.addAndReturn(closeables, metricReader);
            }
            throw new ConfigurationException("prometheus is the only currently supported pull reader");
        }
        throw new ConfigurationException("reader must be set");
    }
}

