/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.SpanLimitsAndAttributeLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.AttributeLimitsModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.SpanLimitsModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.SpanLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.SpanLimitsBuilder;
import java.io.Closeable;
import java.util.List;

final class SpanLimitsFactory
implements Factory<SpanLimitsAndAttributeLimits, SpanLimits> {
    private static final SpanLimitsFactory INSTANCE = new SpanLimitsFactory();

    private SpanLimitsFactory() {
    }

    static SpanLimitsFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SpanLimits create(SpanLimitsAndAttributeLimits model, SpiHelper spiHelper, List<Closeable> closeables) {
        SpanLimitsModel spanLimitsModel;
        SpanLimitsBuilder builder = SpanLimits.builder();
        AttributeLimitsModel attributeLimitsModel = model.getAttributeLimits();
        if (attributeLimitsModel != null) {
            if (attributeLimitsModel.getAttributeCountLimit() != null) {
                builder.setMaxNumberOfAttributes(attributeLimitsModel.getAttributeCountLimit());
            }
            if (attributeLimitsModel.getAttributeValueLengthLimit() != null) {
                builder.setMaxAttributeValueLength(attributeLimitsModel.getAttributeValueLengthLimit());
            }
        }
        if ((spanLimitsModel = model.getSpanLimits()) != null) {
            if (spanLimitsModel.getAttributeCountLimit() != null) {
                builder.setMaxNumberOfAttributes(spanLimitsModel.getAttributeCountLimit());
            }
            if (spanLimitsModel.getAttributeValueLengthLimit() != null) {
                builder.setMaxAttributeValueLength(spanLimitsModel.getAttributeValueLengthLimit());
            }
            if (spanLimitsModel.getEventCountLimit() != null) {
                builder.setMaxNumberOfEvents(spanLimitsModel.getEventCountLimit());
            }
            if (spanLimitsModel.getLinkCountLimit() != null) {
                builder.setMaxNumberOfLinks(spanLimitsModel.getLinkCountLimit());
            }
            if (spanLimitsModel.getEventAttributeCountLimit() != null) {
                builder.setMaxNumberOfAttributesPerEvent(spanLimitsModel.getEventAttributeCountLimit());
            }
            if (spanLimitsModel.getLinkAttributeCountLimit() != null) {
                builder.setMaxNumberOfAttributesPerLink(spanLimitsModel.getLinkAttributeCountLimit());
            }
        }
        return builder.build();
    }
}

