/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.SamplerFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.SpanLimitsAndAttributeLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.SpanLimitsFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.SpanProcessorFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.TracerProviderAndAttributeLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.SpanProcessorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.extension.incubator.fileconfig.internal.model.TracerProviderModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.SdkTracerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.SdkTracerProviderBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.SpanLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.trace.samplers.Sampler;
import java.io.Closeable;
import java.util.List;

final class TracerProviderFactory
implements Factory<TracerProviderAndAttributeLimits, SdkTracerProviderBuilder> {
    private static final TracerProviderFactory INSTANCE = new TracerProviderFactory();

    private TracerProviderFactory() {
    }

    static TracerProviderFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SdkTracerProviderBuilder create(TracerProviderAndAttributeLimits model, SpiHelper spiHelper, List<Closeable> closeables) {
        List<SpanProcessorModel> processors;
        SdkTracerProviderBuilder builder = SdkTracerProvider.builder();
        TracerProviderModel tracerProviderModel = model.getTracerProvider();
        if (tracerProviderModel == null) {
            return builder;
        }
        SpanLimits spanLimits = SpanLimitsFactory.getInstance().create(SpanLimitsAndAttributeLimits.create(model.getAttributeLimits(), tracerProviderModel.getLimits()), spiHelper, closeables);
        builder.setSpanLimits(spanLimits);
        if (tracerProviderModel.getSampler() != null) {
            Sampler sampler = SamplerFactory.getInstance().create(tracerProviderModel.getSampler(), spiHelper, closeables);
            builder.setSampler(sampler);
        }
        if ((processors = tracerProviderModel.getProcessors()) != null) {
            processors.forEach(processor -> builder.addSpanProcessor(SpanProcessorFactory.getInstance().create((SpanProcessorModel)processor, spiHelper, closeables)));
        }
        return builder;
    }
}

