/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.incubator.metrics.ExtendedLongHistogram;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.incubator.metrics.ExtendedLongHistogramBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.metrics.LongHistogramBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.internal.ThrottlingLogger;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.AbstractInstrument;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.InstrumentBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.InstrumentValueType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.SdkMeter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.descriptor.Advice;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class SdkLongHistogram
extends AbstractInstrument
implements ExtendedLongHistogram {
    private static final Logger logger = Logger.getLogger(SdkLongHistogram.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final SdkMeter sdkMeter;
    private final WriteableMetricStorage storage;

    private SdkLongHistogram(InstrumentDescriptor descriptor, SdkMeter sdkMeter, WriteableMetricStorage storage) {
        super(descriptor);
        this.sdkMeter = sdkMeter;
        this.storage = storage;
    }

    @Override
    public void record(long value, Attributes attributes, Context context) {
        if (value < 0L) {
            this.throttlingLogger.log(Level.WARNING, "Histograms can only record non-negative values. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordLong(value, attributes, context);
    }

    @Override
    public void record(long value, Attributes attributes) {
        this.record(value, attributes, Context.current());
    }

    @Override
    public void record(long value) {
        this.record(value, Attributes.empty());
    }

    @Override
    public boolean isEnabled() {
        return this.sdkMeter.isMeterEnabled() && this.storage.isEnabled();
    }

    static final class SdkLongHistogramBuilder
    implements ExtendedLongHistogramBuilder {
        private final InstrumentBuilder builder;

        SdkLongHistogramBuilder(SdkMeter sdkMeter, String name, String description, String unit, Advice.AdviceBuilder adviceBuilder) {
            this.builder = new InstrumentBuilder(name, InstrumentType.HISTOGRAM, InstrumentValueType.LONG, sdkMeter).setDescription(description).setUnit(unit).setAdviceBuilder(adviceBuilder);
        }

        @Override
        public LongHistogramBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public LongHistogramBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkLongHistogram build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1, x$2) -> new SdkLongHistogram(x$0, x$1, x$2));
        }

        @Override
        public LongHistogramBuilder setExplicitBucketBoundariesAdvice(List<Long> bucketBoundaries) {
            List<Double> boundaries;
            try {
                Objects.requireNonNull(bucketBoundaries, "bucketBoundaries must not be null");
                boundaries = bucketBoundaries.stream().map(Long::doubleValue).collect(Collectors.toList());
                ExplicitBucketHistogramUtils.validateBucketBoundaries(boundaries);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                logger.warning("Error setting explicit bucket boundaries advice: " + e.getMessage());
                return this;
            }
            this.builder.setExplicitBucketBoundaries(boundaries);
            return this;
        }

        @Override
        public ExtendedLongHistogramBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.builder.setAdviceAttributes(attributes);
            return this;
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

