/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.aggregator;

import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.data.ExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.data.PointData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.exemplar.ExemplarReservoir;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AggregatorHandle<T extends PointData, U extends ExemplarData> {
    private final ExemplarReservoir<U> exemplarReservoir;
    private volatile boolean valuesRecorded = false;

    protected AggregatorHandle(ExemplarReservoir<U> exemplarReservoir) {
        this.exemplarReservoir = exemplarReservoir;
    }

    public final T aggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, boolean reset) {
        if (reset) {
            this.valuesRecorded = false;
        }
        return this.doAggregateThenMaybeReset(startEpochNanos, epochNanos, attributes, this.exemplarReservoir.collectAndReset(attributes), reset);
    }

    protected abstract T doAggregateThenMaybeReset(long var1, long var3, Attributes var5, List<U> var6, boolean var7);

    public final void recordLong(long value, Attributes attributes, Context context) {
        this.exemplarReservoir.offerLongMeasurement(value, attributes, context);
        this.recordLong(value);
    }

    public final void recordLong(long value) {
        this.doRecordLong(value);
        this.valuesRecorded = true;
    }

    protected void doRecordLong(long value) {
        throw new UnsupportedOperationException("This aggregator does not support recording long values.");
    }

    public final void recordDouble(double value, Attributes attributes, Context context) {
        this.exemplarReservoir.offerDoubleMeasurement(value, attributes, context);
        this.recordDouble(value);
    }

    public final void recordDouble(double value) {
        this.doRecordDouble(value);
        this.valuesRecorded = true;
    }

    protected void doRecordDouble(double value) {
        throw new UnsupportedOperationException("This aggregator does not support recording double values.");
    }

    public boolean hasRecordedValues() {
        return this.valuesRecorded;
    }
}

