/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_12_0_alpha.sdk.metrics.internal.state;

import javax.annotation.Nullable;

public final class ArrayBasedStack<T> {
    static final int DEFAULT_CAPACITY = 10;
    private T[] array = new Object[10];
    private int size = 0;

    public void push(T element) {
        if (element == null) {
            throw new NullPointerException("Null is not permitted as element in the stack");
        }
        if (this.size == this.array.length) {
            this.resizeArray(this.array.length * 2);
        }
        this.array[this.size++] = element;
    }

    @Nullable
    public T pop() {
        if (this.isEmpty()) {
            return null;
        }
        T element = this.array[this.size - 1];
        this.array[this.size - 1] = null;
        --this.size;
        return element;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    private void resizeArray(int newCapacity) {
        Object[] newArray = new Object[newCapacity];
        System.arraycopy(this.array, 0, newArray, 0, this.size);
        this.array = newArray;
    }
}

