/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.ForwardingExecutorService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ContextExecutorService
extends ForwardingExecutorService {
    private final Context context;

    ContextExecutorService(Context context, ExecutorService delegate) {
        super(delegate);
        this.context = context;
    }

    final Context context() {
        return this.context;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate().submit(this.context.wrap(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate().submit(this.context.wrap(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate().submit(this.context.wrap(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate().invokeAll(ContextExecutorService.wrap(this.context, tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException {
        return this.delegate().invokeAll(ContextExecutorService.wrap(this.context, tasks), timeout2, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate().invokeAny(ContextExecutorService.wrap(this.context, tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate().invokeAny(ContextExecutorService.wrap(this.context, tasks), timeout2, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate().execute(this.context.wrap(command));
    }
}

