/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.metrics.LongCounter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.metrics.Meter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.metrics.MeterProvider;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ExporterMetrics {
    private static final AttributeKey<String> ATTRIBUTE_KEY_TYPE = AttributeKey.stringKey("type");
    private static final AttributeKey<Boolean> ATTRIBUTE_KEY_SUCCESS = AttributeKey.booleanKey("success");
    private final Supplier<MeterProvider> meterProviderSupplier;
    private final String exporterName;
    private final String transportName;
    private final Attributes seenAttrs;
    private final Attributes successAttrs;
    private final Attributes failedAttrs;
    @Nullable
    private volatile LongCounter seen;
    @Nullable
    private volatile LongCounter exported;

    private ExporterMetrics(Supplier<MeterProvider> meterProviderSupplier, String exporterName, String type, String transportName) {
        this.meterProviderSupplier = meterProviderSupplier;
        this.exporterName = exporterName;
        this.transportName = transportName;
        this.seenAttrs = Attributes.builder().put(ATTRIBUTE_KEY_TYPE, type).build();
        this.successAttrs = this.seenAttrs.toBuilder().put(ATTRIBUTE_KEY_SUCCESS, Boolean.valueOf(true)).build();
        this.failedAttrs = this.seenAttrs.toBuilder().put(ATTRIBUTE_KEY_SUCCESS, Boolean.valueOf(false)).build();
    }

    public void addSeen(long value) {
        this.seen().add(value, this.seenAttrs);
    }

    public void addSuccess(long value) {
        this.exported().add(value, this.successAttrs);
    }

    public void addFailed(long value) {
        this.exported().add(value, this.failedAttrs);
    }

    private LongCounter seen() {
        LongCounter seen = this.seen;
        if (seen == null || ExporterMetrics.isNoop(seen)) {
            this.seen = seen = this.meter().counterBuilder(this.exporterName + ".exporter.seen").build();
        }
        return seen;
    }

    private LongCounter exported() {
        LongCounter exported = this.exported;
        if (exported == null || ExporterMetrics.isNoop(exported)) {
            this.exported = exported = this.meter().counterBuilder(this.exporterName + ".exporter.exported").build();
        }
        return exported;
    }

    private Meter meter() {
        MeterProvider meterProvider = this.meterProviderSupplier.get();
        if (meterProvider == null) {
            meterProvider = MeterProvider.noop();
        }
        return meterProvider.get("io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporters." + this.exporterName + "-" + this.transportName);
    }

    private static boolean isNoop(LongCounter counter) {
        return counter.getClass().getSimpleName().startsWith("Noop");
    }

    public static ExporterMetrics createGrpc(String exporterName, String type, Supplier<MeterProvider> meterProvider) {
        return new ExporterMetrics(meterProvider, exporterName, type, "grpc");
    }

    public static ExporterMetrics createGrpcOkHttp(String exporterName, String type, Supplier<MeterProvider> meterProvider) {
        return new ExporterMetrics(meterProvider, exporterName, type, "grpc-okhttp");
    }

    public static ExporterMetrics createHttpProtobuf(String exporterName, String type, Supplier<MeterProvider> meterProvider) {
        return new ExporterMetrics(meterProvider, exporterName, type, "http");
    }

    public static ExporterMetrics createHttpJson(String exporterName, String type, Supplier<MeterProvider> meterProvider) {
        return new ExporterMetrics(meterProvider, exporterName, type, "http-json");
    }
}

