/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.config.DeclarativeConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.Aggregation;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export.AggregationTemporalitySelector;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export.DefaultAggregationSelector;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.aggregator.AggregationUtil;
import java.util.Locale;
import java.util.function.Consumer;

public final class IncubatingExporterBuilderUtil {
    public static void configureExporterMemoryMode(DeclarativeConfigProperties config, Consumer<MemoryMode> memoryModeConsumer) {
        MemoryMode memoryMode;
        String memoryModeStr = config.getString("memory_mode");
        if (memoryModeStr == null) {
            return;
        }
        try {
            memoryMode = MemoryMode.valueOf(memoryModeStr.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Unrecognized memory_mode: " + memoryModeStr, e);
        }
        memoryModeConsumer.accept(memoryMode);
    }

    public static void configureOtlpAggregationTemporality(DeclarativeConfigProperties config, Consumer<AggregationTemporalitySelector> aggregationTemporalitySelectorConsumer) {
        AggregationTemporalitySelector temporalitySelector;
        String temporalityStr = config.getString("temporality_preference");
        if (temporalityStr == null) {
            return;
        }
        switch (temporalityStr.toLowerCase(Locale.ROOT)) {
            case "cumulative": {
                temporalitySelector = AggregationTemporalitySelector.alwaysCumulative();
                break;
            }
            case "delta": {
                temporalitySelector = AggregationTemporalitySelector.deltaPreferred();
                break;
            }
            case "lowmemory": {
                temporalitySelector = AggregationTemporalitySelector.lowMemory();
                break;
            }
            default: {
                throw new ConfigurationException("Unrecognized temporality_preference: " + temporalityStr);
            }
        }
        aggregationTemporalitySelectorConsumer.accept(temporalitySelector);
    }

    public static void configureOtlpHistogramDefaultAggregation(DeclarativeConfigProperties config, Consumer<DefaultAggregationSelector> defaultAggregationSelectorConsumer) {
        String defaultHistogramAggregation = config.getString("default_histogram_aggregation");
        if (defaultHistogramAggregation == null) {
            return;
        }
        if (AggregationUtil.aggregationName(Aggregation.base2ExponentialBucketHistogram()).equalsIgnoreCase(defaultHistogramAggregation)) {
            defaultAggregationSelectorConsumer.accept(DefaultAggregationSelector.getDefault().with(InstrumentType.HISTOGRAM, Aggregation.base2ExponentialBucketHistogram()));
        } else if (!AggregationUtil.aggregationName(Aggregation.explicitBucketHistogram()).equalsIgnoreCase(defaultHistogramAggregation)) {
            throw new ConfigurationException("Unrecognized default_histogram_aggregation: " + defaultHistogramAggregation);
        }
    }

    private IncubatingExporterBuilderUtil() {
    }
}

