/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.CodedOutputStream;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.proto.common.v1.internal.AnyValue;
import java.io.IOException;

final class StringAnyValueMarshaler
extends MarshalerWithSize {
    private final byte[] valueUtf8;

    private StringAnyValueMarshaler(byte[] valueUtf8) {
        super(StringAnyValueMarshaler.calculateSize(valueUtf8));
        this.valueUtf8 = valueUtf8;
    }

    static MarshalerWithSize create(String value) {
        return new StringAnyValueMarshaler(MarshalerUtil.toBytes(value));
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        if (this.valueUtf8.length == 0) {
            return;
        }
        output.writeString(AnyValue.STRING_VALUE, this.valueUtf8);
    }

    private static int calculateSize(byte[] valueUtf8) {
        if (valueUtf8.length == 0) {
            return 0;
        }
        return AnyValue.STRING_VALUE.getTagSize() + CodedOutputStream.computeByteArraySizeNoTag(valueUtf8);
    }
}

