/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.otlp.http.logs;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.internal.Utils;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.metrics.MeterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.compression.Compressor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.compression.CompressorUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.http.HttpExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.otlp.internal.OtlpUserAgent;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.export.ProxyOptions;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.export.RetryPolicy;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpHttpLogRecordExporterBuilder {
    private static final String DEFAULT_ENDPOINT = "http://localhost:4318/v1/logs";
    private static final MemoryMode DEFAULT_MEMORY_MODE = MemoryMode.REUSABLE_DATA;
    private final HttpExporterBuilder<Marshaler> delegate;
    private MemoryMode memoryMode;

    OtlpHttpLogRecordExporterBuilder(HttpExporterBuilder<Marshaler> delegate, MemoryMode memoryMode) {
        this.delegate = delegate;
        this.memoryMode = memoryMode;
        OtlpUserAgent.addUserAgentHeader(delegate::addConstantHeaders);
    }

    OtlpHttpLogRecordExporterBuilder() {
        this(new HttpExporterBuilder<Marshaler>("otlp", "log", DEFAULT_ENDPOINT), DEFAULT_MEMORY_MODE);
    }

    public OtlpHttpLogRecordExporterBuilder setTimeout(long timeout2, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout2 >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(timeout2, unit);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setTimeout(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        return this.setTimeout(timeout2.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpLogRecordExporterBuilder setConnectTimeout(long timeout2, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout2 >= 0L, "timeout must be non-negative");
        this.delegate.setConnectTimeout(timeout2, unit);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setConnectTimeout(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        return this.setConnectTimeout(timeout2.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpLogRecordExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Compressor compressor = CompressorUtil.validateAndResolveCompressor(compressionMethod);
        this.delegate.setCompression(compressor);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder addHeader(String key, String value) {
        this.delegate.addConstantHeaders(key, value);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setHeaders(Supplier<Map<String, String>> headerSupplier) {
        this.delegate.setHeadersSupplier(headerSupplier);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.delegate.setSslContext(sslContext, trustManager);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setProxyOptions(ProxyOptions proxyOptions) {
        Objects.requireNonNull(proxyOptions, "proxyOptions");
        this.delegate.setProxyOptions(proxyOptions);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.setMeterProvider(() -> meterProvider);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setMeterProvider(Supplier<MeterProvider> meterProviderSupplier) {
        Objects.requireNonNull(meterProviderSupplier, "meterProviderSupplier");
        this.delegate.setMeterProvider(meterProviderSupplier);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setMemoryMode(MemoryMode memoryMode) {
        Objects.requireNonNull(memoryMode, "memoryMode");
        this.memoryMode = memoryMode;
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setServiceClassLoader(ClassLoader serviceClassLoader) {
        Objects.requireNonNull(serviceClassLoader, "serviceClassLoader");
        this.delegate.setServiceClassLoader(serviceClassLoader);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setExecutorService(ExecutorService executorService) {
        Objects.requireNonNull(executorService, "executorService");
        this.delegate.setExecutorService(executorService);
        return this;
    }

    public OtlpHttpLogRecordExporter build() {
        return new OtlpHttpLogRecordExporter(this.delegate, this.delegate.build(), this.memoryMode);
    }
}

