/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.otlp.logs;

import io.grpc.ManagedChannel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.internal.Utils;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.metrics.MeterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.compression.Compressor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.compression.CompressorUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.grpc.GrpcExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.otlp.internal.OtlpUserAgent;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.otlp.logs.MarshalerLogsServiceGrpc;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.export.RetryPolicy;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpGrpcLogRecordExporterBuilder {
    private static final String GRPC_SERVICE_NAME = "opentelemetry.proto.collector.logs.v1.LogsService";
    static final String GRPC_ENDPOINT_PATH = "/opentelemetry.proto.collector.logs.v1.LogsService/Export";
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:4317";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:4317");
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private static final MemoryMode DEFAULT_MEMORY_MODE = MemoryMode.REUSABLE_DATA;
    final GrpcExporterBuilder<Marshaler> delegate;
    private MemoryMode memoryMode;

    OtlpGrpcLogRecordExporterBuilder(GrpcExporterBuilder<Marshaler> delegate, MemoryMode memoryMode) {
        this.delegate = delegate;
        this.memoryMode = memoryMode;
        OtlpUserAgent.addUserAgentHeader(delegate::addConstantHeader);
    }

    OtlpGrpcLogRecordExporterBuilder() {
        this(new GrpcExporterBuilder<Marshaler>("otlp", "log", 10L, DEFAULT_ENDPOINT, () -> MarshalerLogsServiceGrpc::newFutureStub, GRPC_ENDPOINT_PATH), DEFAULT_MEMORY_MODE);
    }

    @Deprecated
    public OtlpGrpcLogRecordExporterBuilder setChannel(ManagedChannel channel) {
        this.delegate.setChannel(channel);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setTimeout(long timeout2, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout2 >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(timeout2, unit);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setTimeout(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        this.delegate.setTimeout(timeout2);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setConnectTimeout(long timeout2, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout2 >= 0L, "timeout must be non-negative");
        this.delegate.setConnectTimeout(timeout2, unit);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setConnectTimeout(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        return this.setConnectTimeout(timeout2.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpGrpcLogRecordExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Compressor compressor = CompressorUtil.validateAndResolveCompressor(compressionMethod);
        this.delegate.setCompression(compressor);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.delegate.setSslContext(sslContext, trustManager);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder addHeader(String key, String value) {
        this.delegate.addConstantHeader(key, value);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setHeaders(Supplier<Map<String, String>> headerSupplier) {
        this.delegate.setHeadersSupplier(headerSupplier);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.setMeterProvider(() -> meterProvider);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setMeterProvider(Supplier<MeterProvider> meterProviderSupplier) {
        Objects.requireNonNull(meterProviderSupplier, "meterProviderSupplier");
        this.delegate.setMeterProvider(meterProviderSupplier);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setMemoryMode(MemoryMode memoryMode) {
        Objects.requireNonNull(memoryMode, "memoryMode");
        this.memoryMode = memoryMode;
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setServiceClassLoader(ClassLoader serviceClassLoader) {
        Objects.requireNonNull(serviceClassLoader, "serviceClassLoader");
        this.delegate.setServiceClassLoader(serviceClassLoader);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setExecutorService(ExecutorService executorService) {
        Objects.requireNonNull(executorService, "executorService");
        this.delegate.setExecutorService(executorService);
        return this;
    }

    public OtlpGrpcLogRecordExporter build() {
        return new OtlpGrpcLogRecordExporter(this.delegate, this.delegate.build(), this.memoryMode);
    }
}

