/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.metrics.ExtendedDoubleHistogramBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.metrics.DoubleHistogramBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.metrics.Meter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.instrumenter.OperationListener;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.instrumenter.OperationMetrics;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OperationMetricsUtil {
    private static final Logger logger = Logger.getLogger(OperationMetricsUtil.class.getName());
    public static final OperationListener NOOP_OPERATION_LISTENER = new OperationListener(){

        @Override
        public Context onStart(Context context, Attributes startAttributes, long startNanos) {
            return context;
        }

        @Override
        public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        }
    };

    public static OperationMetrics create(String description, Function<Meter, OperationListener> factory2) {
        return OperationMetricsUtil.create(description, factory2, (s, histogramBuilder) -> logger.log(Level.WARNING, "Disabling {0} metrics because {1} does not implement {2}. This prevents using metrics advice, which could result in {0} metrics having high cardinality attributes.", new Object[]{description, histogramBuilder.getClass().getName(), ExtendedDoubleHistogramBuilder.class.getName()}));
    }

    static OperationMetrics create(String description, Function<Meter, OperationListener> factory2, BiConsumer<String, DoubleHistogramBuilder> warningEmitter) {
        return meter -> {
            DoubleHistogramBuilder histogramBuilder = meter.histogramBuilder("compatibility-test");
            if (!(histogramBuilder instanceof ExtendedDoubleHistogramBuilder) && !histogramBuilder.getClass().getName().contains("NoopDoubleHistogram")) {
                warningEmitter.accept(description, histogramBuilder);
                return NOOP_OPERATION_LISTENER;
            }
            return (OperationListener)factory2.apply(meter);
        };
    }

    private OperationMetricsUtil() {
    }
}

