/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure.internal.NamedSpiManager;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure.spi.ConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.trace.export.SpanExporter;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

final class SpanExporterConfiguration {
    private static final String EXPORTER_NONE = "none";
    private static final Map<String, String> EXPORTER_ARTIFACT_ID_BY_NAME = new HashMap<String, String>();

    static Map<String, SpanExporter> configureSpanExporters(ConfigProperties config, SpiHelper spiHelper, BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> spanExporterCustomizer, List<Closeable> closeables) {
        Set<String> exporterNames = DefaultConfigProperties.getSet(config, "otel.traces.exporter");
        if (exporterNames.contains(EXPORTER_NONE)) {
            if (exporterNames.size() > 1) {
                throw new ConfigurationException("otel.traces.exporter contains none along with other exporters");
            }
            return Collections.emptyMap();
        }
        if (exporterNames.isEmpty()) {
            exporterNames = Collections.singleton("otlp");
        }
        NamedSpiManager<SpanExporter> spiExportersManager = SpanExporterConfiguration.spanExporterSpiManager(config, spiHelper);
        HashMap<String, SpanExporter> map = new HashMap<String, SpanExporter>();
        for (String exporterName : exporterNames) {
            SpanExporter spanExporter = SpanExporterConfiguration.configureExporter(exporterName, spiExportersManager);
            closeables.add(spanExporter);
            SpanExporter customizedSpanExporter = spanExporterCustomizer.apply(spanExporter, config);
            if (customizedSpanExporter != spanExporter) {
                closeables.add(customizedSpanExporter);
            }
            map.put(exporterName, customizedSpanExporter);
        }
        return Collections.unmodifiableMap(map);
    }

    static NamedSpiManager<SpanExporter> spanExporterSpiManager(ConfigProperties config, SpiHelper spiHelper) {
        return spiHelper.loadConfigurable(ConfigurableSpanExporterProvider.class, ConfigurableSpanExporterProvider::getName, ConfigurableSpanExporterProvider::createExporter, config);
    }

    static SpanExporter configureExporter(String name, NamedSpiManager<SpanExporter> spiExportersManager) {
        SpanExporter spiExporter = spiExportersManager.getByName(name);
        if (spiExporter == null) {
            String artifactId = EXPORTER_ARTIFACT_ID_BY_NAME.get(name);
            if (artifactId != null) {
                throw new ConfigurationException("otel.traces.exporter set to \"" + name + "\" but " + artifactId + " not found on classpath. Make sure to add it as a dependency.");
            }
            throw new ConfigurationException("Unrecognized value for otel.traces.exporter: " + name);
        }
        return spiExporter;
    }

    private SpanExporterConfiguration() {
    }

    static {
        EXPORTER_ARTIFACT_ID_BY_NAME.put("console", "opentelemetry-exporter-logging");
        EXPORTER_ARTIFACT_ID_BY_NAME.put("jaeger", "opentelemetry-exporter-jaeger");
        EXPORTER_ARTIFACT_ID_BY_NAME.put("logging", "opentelemetry-exporter-logging");
        EXPORTER_ARTIFACT_ID_BY_NAME.put("logging-otlp", "opentelemetry-exporter-logging-otlp");
        EXPORTER_ARTIFACT_ID_BY_NAME.put("otlp", "opentelemetry-exporter-otlp");
        EXPORTER_ARTIFACT_ID_BY_NAME.put("zipkin", "opentelemetry-exporter-zipkin");
    }
}

