/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.LogRecordExporterFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.BatchLogRecordProcessorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.LogRecordExporterModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.LogRecordProcessorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.SimpleLogRecordProcessorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.LogRecordProcessor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.export.BatchLogRecordProcessor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.export.BatchLogRecordProcessorBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.export.LogRecordExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.export.SimpleLogRecordProcessor;
import java.time.Duration;
import java.util.Map;

final class LogRecordProcessorFactory
implements Factory<LogRecordProcessorModel, LogRecordProcessor> {
    private static final LogRecordProcessorFactory INSTANCE = new LogRecordProcessorFactory();

    private LogRecordProcessorFactory() {
    }

    static LogRecordProcessorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public LogRecordProcessor create(LogRecordProcessorModel model, DeclarativeConfigContext context) {
        BatchLogRecordProcessorModel batchModel = model.getBatch();
        if (batchModel != null) {
            LogRecordExporterModel exporterModel = FileConfigUtil.requireNonNull(batchModel.getExporter(), "batch log record processor exporter");
            LogRecordExporter logRecordExporter = LogRecordExporterFactory.getInstance().create(exporterModel, context);
            BatchLogRecordProcessorBuilder builder = BatchLogRecordProcessor.builder(logRecordExporter);
            if (batchModel.getExportTimeout() != null) {
                builder.setExporterTimeout(Duration.ofMillis(batchModel.getExportTimeout().intValue()));
            }
            if (batchModel.getMaxExportBatchSize() != null) {
                builder.setMaxExportBatchSize(batchModel.getMaxExportBatchSize());
            }
            if (batchModel.getMaxQueueSize() != null) {
                builder.setMaxQueueSize(batchModel.getMaxQueueSize());
            }
            if (batchModel.getScheduleDelay() != null) {
                builder.setScheduleDelay(Duration.ofMillis(batchModel.getScheduleDelay().intValue()));
            }
            return context.addCloseable(builder.build());
        }
        SimpleLogRecordProcessorModel simpleModel = model.getSimple();
        if (simpleModel != null) {
            LogRecordExporterModel exporterModel = FileConfigUtil.requireNonNull(simpleModel.getExporter(), "simple log record processor exporter");
            LogRecordExporter logRecordExporter = LogRecordExporterFactory.getInstance().create(exporterModel, context);
            return context.addCloseable(SimpleLogRecordProcessor.create(logRecordExporter));
        }
        Map.Entry<String, Object> keyValue = FileConfigUtil.getSingletonMapEntry(model.getAdditionalProperties(), "log record processor");
        LogRecordProcessor logRecordProcessor = context.loadComponent(LogRecordProcessor.class, keyValue.getKey(), keyValue.getValue());
        return context.addCloseable(logRecordProcessor);
    }
}

