/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure.ResourceConfiguration;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.AttributeListFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.ResourceDetectorFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.AttributeNameValueModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ExperimentalResourceDetectionModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ExperimentalResourceDetectorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.IncludeExcludeModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ResourceModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.internal.GlobUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.resources.Resource;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.resources.ResourceBuilder;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class ResourceFactory
implements Factory<ResourceModel, Resource> {
    private static final ResourceFactory INSTANCE = new ResourceFactory();

    private ResourceFactory() {
    }

    static ResourceFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public Resource create(ResourceModel model, DeclarativeConfigContext context) {
        List<AttributeNameValueModel> attributeNameValueModel;
        String attributeList;
        ResourceBuilder builder = Resource.getDefault().toBuilder();
        ExperimentalResourceDetectionModel detectionModel = model.getDetectionDevelopment();
        if (detectionModel != null) {
            ResourceBuilder detectedResourceBuilder = Resource.builder();
            List<ExperimentalResourceDetectorModel> detectorModels = detectionModel.getDetectors();
            if (detectorModels != null) {
                for (ExperimentalResourceDetectorModel detectorModel : detectorModels) {
                    detectedResourceBuilder.putAll(ResourceDetectorFactory.getInstance().create(detectorModel, context));
                }
            }
            Predicate<String> detectorAttributeFilter = ResourceFactory.detectorAttributeFilter(detectionModel.getAttributes());
            Attributes filteredDetectedAttributes = detectedResourceBuilder.build().getAttributes().toBuilder().removeIf(attributeKey -> !detectorAttributeFilter.test(attributeKey.getKey())).build();
            builder.putAll(filteredDetectedAttributes);
        }
        if ((attributeList = model.getAttributesList()) != null) {
            builder.putAll(ResourceConfiguration.createEnvironmentResource(DefaultConfigProperties.createFromMap(Collections.singletonMap("otel.resource.attributes", attributeList))));
        }
        if ((attributeNameValueModel = model.getAttributes()) != null) {
            builder.putAll(AttributeListFactory.getInstance().create(attributeNameValueModel, context)).build();
        }
        return builder.build();
    }

    private static boolean matchAll(String attributeKey) {
        return true;
    }

    private static Predicate<String> detectorAttributeFilter(@Nullable IncludeExcludeModel includedExcludeModel) {
        if (includedExcludeModel == null) {
            return ResourceFactory::matchAll;
        }
        List<String> included = includedExcludeModel.getIncluded();
        List<String> excluded = includedExcludeModel.getExcluded();
        if (included == null && excluded == null) {
            return ResourceFactory::matchAll;
        }
        if (included == null) {
            return ResourceFactory.excludedPredicate(excluded);
        }
        if (excluded == null) {
            return ResourceFactory.includedPredicate(included);
        }
        return ResourceFactory.includedPredicate(included).and(ResourceFactory.excludedPredicate(excluded));
    }

    private static Predicate<String> includedPredicate(List<String> included) {
        Predicate<String> result = attributeKey -> false;
        for (String include : included) {
            result = result.or(GlobUtil.createGlobPatternPredicate(include));
        }
        return result;
    }

    private static Predicate<String> excludedPredicate(List<String> excluded) {
        Predicate<String> result = attributeKey -> true;
        for (String exclude : excluded) {
            result = result.and(GlobUtil.createGlobPatternPredicate(exclude).negate());
        }
        return result;
    }
}

