/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.SamplerFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.SpanLimitsAndAttributeLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.SpanLimitsFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.SpanProcessorFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.TracerProviderAndAttributeLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ExperimentalTracerConfigModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ExperimentalTracerConfiguratorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ExperimentalTracerMatcherAndConfigModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.SpanProcessorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.TracerProviderModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.internal.ScopeConfigurator;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.internal.ScopeConfiguratorBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.trace.SdkTracerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.trace.SdkTracerProviderBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.trace.SpanLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.trace.internal.SdkTracerProviderUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.trace.internal.TracerConfig;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.trace.samplers.Sampler;
import java.util.List;

final class TracerProviderFactory
implements Factory<TracerProviderAndAttributeLimits, SdkTracerProviderBuilder> {
    private static final TracerProviderFactory INSTANCE = new TracerProviderFactory();

    private TracerProviderFactory() {
    }

    static TracerProviderFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SdkTracerProviderBuilder create(TracerProviderAndAttributeLimits model, DeclarativeConfigContext context) {
        ExperimentalTracerConfiguratorModel tracerConfiguratorModel;
        List<SpanProcessorModel> processors;
        SdkTracerProviderBuilder builder = SdkTracerProvider.builder();
        TracerProviderModel tracerProviderModel = model.getTracerProvider();
        if (tracerProviderModel == null) {
            return builder;
        }
        SpanLimits spanLimits = SpanLimitsFactory.getInstance().create(SpanLimitsAndAttributeLimits.create(model.getAttributeLimits(), tracerProviderModel.getLimits()), context);
        builder.setSpanLimits(spanLimits);
        if (tracerProviderModel.getSampler() != null) {
            Sampler sampler = SamplerFactory.getInstance().create(tracerProviderModel.getSampler(), context);
            builder.setSampler(sampler);
        }
        if ((processors = tracerProviderModel.getProcessors()) != null) {
            processors.forEach(processor -> builder.addSpanProcessor(SpanProcessorFactory.getInstance().create((SpanProcessorModel)processor, context)));
        }
        if ((tracerConfiguratorModel = tracerProviderModel.getTracerConfiguratorDevelopment()) != null) {
            List<ExperimentalTracerMatcherAndConfigModel> tracerMatcherAndConfigs;
            ExperimentalTracerConfigModel defaultConfigModel = tracerConfiguratorModel.getDefaultConfig();
            ScopeConfiguratorBuilder<TracerConfig> configuratorBuilder = ScopeConfigurator.builder();
            if (defaultConfigModel != null) {
                configuratorBuilder.setDefault(TracerConfigFactory.INSTANCE.create(defaultConfigModel, context));
            }
            if ((tracerMatcherAndConfigs = tracerConfiguratorModel.getTracers()) != null) {
                for (ExperimentalTracerMatcherAndConfigModel tracerMatcherAndConfig : tracerMatcherAndConfigs) {
                    String name = FileConfigUtil.requireNonNull(tracerMatcherAndConfig.getName(), "tracer matcher name");
                    ExperimentalTracerConfigModel config = tracerMatcherAndConfig.getConfig();
                    if (name == null || config == null) continue;
                    configuratorBuilder.addCondition(ScopeConfiguratorBuilder.nameMatchesGlob(name), TracerConfigFactory.INSTANCE.create(config, context));
                }
            }
            SdkTracerProviderUtil.setTracerConfigurator(builder, configuratorBuilder.build());
        }
        return builder;
    }

    private static class TracerConfigFactory
    implements Factory<ExperimentalTracerConfigModel, TracerConfig> {
        private static final TracerConfigFactory INSTANCE = new TracerConfigFactory();

        private TracerConfigFactory() {
        }

        @Override
        public TracerConfig create(ExperimentalTracerConfigModel model, DeclarativeConfigContext context) {
            if (model.getDisabled() != null && model.getDisabled().booleanValue()) {
                return TracerConfig.disabled();
            }
            return TracerConfig.defaultConfig();
        }
    }
}

