/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.internal;

import java.util.AbstractList;
import java.util.Arrays;

public class DynamicPrimitiveLongList
extends AbstractList<Long> {
    private static final int DEFAULT_SUBARRAY_CAPACITY = 10;
    private final int subarrayCapacity;
    private long[][] arrays;
    private int size;
    private int arrayCount;

    public static DynamicPrimitiveLongList of(long ... values2) {
        DynamicPrimitiveLongList list = new DynamicPrimitiveLongList();
        list.resizeAndClear(values2.length);
        for (int i = 0; i < values2.length; ++i) {
            list.setLong(i, values2[i]);
        }
        return list;
    }

    public static DynamicPrimitiveLongList ofSubArrayCapacity(int subarrayCapacity) {
        return new DynamicPrimitiveLongList(subarrayCapacity);
    }

    public static DynamicPrimitiveLongList empty() {
        return new DynamicPrimitiveLongList();
    }

    DynamicPrimitiveLongList() {
        this(10);
    }

    DynamicPrimitiveLongList(int subarrayCapacity) {
        if (subarrayCapacity <= 0) {
            throw new IllegalArgumentException("Subarray capacity must be positive");
        }
        this.subarrayCapacity = subarrayCapacity;
        this.arrays = new long[0][subarrayCapacity];
        this.arrayCount = 0;
        this.size = 0;
    }

    @Override
    public Long get(int index) {
        return this.getLong(index);
    }

    public long getLong(int index) {
        this.rangeCheck(index);
        return this.arrays[index / this.subarrayCapacity][index % this.subarrayCapacity];
    }

    @Override
    public Long set(int index, Long element) {
        return this.setLong(index, element);
    }

    public long setLong(int index, long element) {
        this.rangeCheck(index);
        long oldValue = this.arrays[index / this.subarrayCapacity][index % this.subarrayCapacity];
        this.arrays[index / this.subarrayCapacity][index % this.subarrayCapacity] = element;
        return oldValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void resizeAndClear(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("New size must be non-negative");
        }
        this.ensureCapacity(newSize);
        this.size = newSize;
        for (int i = 0; i < newSize; ++i) {
            this.setLong(i, 0L);
        }
    }

    private void ensureCapacity(int minCapacity) {
        int requiredArrays = (minCapacity + this.subarrayCapacity - 1) / this.subarrayCapacity;
        if (requiredArrays > this.arrayCount) {
            this.arrays = (long[][])Arrays.copyOf(this.arrays, requiredArrays);
            for (int i = this.arrayCount; i < requiredArrays; ++i) {
                this.arrays[i] = new long[this.subarrayCapacity];
            }
            this.arrayCount = requiredArrays;
        }
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }
}

