/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.Value;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.logs.Severity;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.trace.SpanContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.internal.AttributesMap;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.LogLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.ReadWriteLogRecord;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.SdkLogRecordData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.data.LogRecordData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.resources.Resource;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class SdkReadWriteLogRecord
implements ReadWriteLogRecord {
    protected final LogLimits logLimits;
    protected final Resource resource;
    protected final InstrumentationScopeInfo instrumentationScopeInfo;
    protected final long timestampEpochNanos;
    protected final long observedTimestampEpochNanos;
    protected final SpanContext spanContext;
    protected final Severity severity;
    @Nullable
    protected final String severityText;
    @Nullable
    protected final Value<?> body;
    @Nullable
    protected String eventName;
    private final Object lock = new Object();
    @Nullable
    private AttributesMap attributes;

    protected SdkReadWriteLogRecord(LogLimits logLimits, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long timestampEpochNanos, long observedTimestampEpochNanos, SpanContext spanContext, Severity severity, @Nullable String severityText, @Nullable Value<?> body, @Nullable AttributesMap attributes, @Nullable String eventName) {
        this.logLimits = logLimits;
        this.resource = resource;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.timestampEpochNanos = timestampEpochNanos;
        this.observedTimestampEpochNanos = observedTimestampEpochNanos;
        this.spanContext = spanContext;
        this.severity = severity;
        this.severityText = severityText;
        this.body = body;
        this.eventName = eventName;
        this.attributes = attributes;
    }

    static SdkReadWriteLogRecord create(LogLimits logLimits, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long timestampEpochNanos, long observedTimestampEpochNanos, SpanContext spanContext, Severity severity, @Nullable String severityText, @Nullable Value<?> body, @Nullable AttributesMap attributes, @Nullable String eventName) {
        return new SdkReadWriteLogRecord(logLimits, resource, instrumentationScopeInfo, timestampEpochNanos, observedTimestampEpochNanos, spanContext, severity, severityText, body, attributes, eventName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ReadWriteLogRecord setAttribute(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null) {
                this.attributes = AttributesMap.create(this.logLimits.getMaxNumberOfAttributes(), this.logLimits.getMaxAttributeValueLength());
            }
            this.attributes.put(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attributes getImmutableAttributes() {
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null || this.attributes.isEmpty()) {
                return Attributes.empty();
            }
            return this.attributes.immutableCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogRecordData toLogRecordData() {
        Object object = this.lock;
        synchronized (object) {
            return SdkLogRecordData.create(this.resource, this.instrumentationScopeInfo, this.timestampEpochNanos, this.observedTimestampEpochNanos, this.spanContext, this.severity, this.severityText, this.body, this.getImmutableAttributes(), this.attributes == null ? 0 : this.attributes.getTotalAddedValues(), this.eventName);
        }
    }

    @Override
    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    @Override
    public long getTimestampEpochNanos() {
        return this.timestampEpochNanos;
    }

    @Override
    public long getObservedTimestampEpochNanos() {
        return this.observedTimestampEpochNanos;
    }

    @Override
    public SpanContext getSpanContext() {
        return this.spanContext;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    @Nullable
    public String getSeverityText() {
        return this.severityText;
    }

    @Override
    @Nullable
    public Value<?> getBodyValue() {
        return this.body;
    }

    @Override
    public Attributes getAttributes() {
        return this.getImmutableAttributes();
    }

    @Override
    @Nullable
    public String getEventName() {
        return this.eventName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T getAttribute(AttributeKey<T> key) {
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null || this.attributes.isEmpty()) {
                return null;
            }
            return this.attributes.get(key);
        }
    }
}

