/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.export;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.data.LogRecordData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.export.MultiLogRecordExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.export.NoopLogRecordExporter;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public interface LogRecordExporter
extends Closeable {
    public static LogRecordExporter composite(LogRecordExporter ... exporters) {
        return LogRecordExporter.composite(Arrays.asList(exporters));
    }

    public static LogRecordExporter composite(Iterable<LogRecordExporter> exporters) {
        ArrayList<LogRecordExporter> exportersList = new ArrayList<LogRecordExporter>();
        for (LogRecordExporter exporter : exporters) {
            exportersList.add(exporter);
        }
        if (exportersList.isEmpty()) {
            return NoopLogRecordExporter.getInstance();
        }
        if (exportersList.size() == 1) {
            return (LogRecordExporter)exportersList.get(0);
        }
        return MultiLogRecordExporter.create(exportersList);
    }

    public CompletableResultCode export(Collection<LogRecordData> var1);

    public CompletableResultCode flush();

    public CompletableResultCode shutdown();

    @Override
    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

