/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.metrics.MeterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.metrics.MeterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.Clock;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.internal.ComponentRegistry;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.internal.ScopeConfigurator;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.SdkMeter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.SdkMeterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.SdkMeterProviderBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.data.MetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export.CardinalityLimitSelector;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export.CollectionRegistration;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export.DefaultAggregationSelector;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export.MetricProducer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export.MetricReader;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.MeterConfig;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.export.RegisteredReader;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.state.MeterProviderSharedState;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.view.RegisteredView;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.view.ViewRegistry;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.resources.Resource;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class SdkMeterProvider
implements MeterProvider,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(SdkMeterProvider.class.getName());
    static final String DEFAULT_METER_NAME = "unknown";
    private final List<RegisteredView> registeredViews;
    private final List<RegisteredReader> registeredReaders;
    private final List<MetricProducer> metricProducers;
    private final MeterProviderSharedState sharedState;
    private final ComponentRegistry<SdkMeter> registry;
    private final ScopeConfigurator<MeterConfig> meterConfigurator;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public static SdkMeterProviderBuilder builder() {
        return new SdkMeterProviderBuilder();
    }

    SdkMeterProvider(List<RegisteredView> registeredViews, IdentityHashMap<MetricReader, CardinalityLimitSelector> metricReaders, List<MetricProducer> metricProducers, Clock clock, Resource resource, ExemplarFilter exemplarFilter, ScopeConfigurator<MeterConfig> meterConfigurator) {
        long startEpochNanos = clock.now();
        this.registeredViews = registeredViews;
        this.registeredReaders = metricReaders.entrySet().stream().map(entry -> RegisteredReader.create((MetricReader)entry.getKey(), ViewRegistry.create((DefaultAggregationSelector)entry.getKey(), (CardinalityLimitSelector)entry.getValue(), registeredViews))).collect(Collectors.toList());
        this.metricProducers = metricProducers;
        this.sharedState = MeterProviderSharedState.create(clock, resource, exemplarFilter, startEpochNanos);
        this.registry = new ComponentRegistry<SdkMeter>(instrumentationLibraryInfo -> new SdkMeter(this.sharedState, (InstrumentationScopeInfo)instrumentationLibraryInfo, this.registeredReaders, this.getMeterConfig((InstrumentationScopeInfo)instrumentationLibraryInfo)));
        this.meterConfigurator = meterConfigurator;
        for (RegisteredReader registeredReader : this.registeredReaders) {
            ArrayList<MetricProducer> readerMetricProducers = new ArrayList<MetricProducer>(metricProducers);
            readerMetricProducers.add(new LeasedMetricProducer(this.registry, this.sharedState, registeredReader));
            registeredReader.getReader().register(new SdkCollectionRegistration(readerMetricProducers, this.sharedState));
            registeredReader.setLastCollectEpochNanos(startEpochNanos);
        }
    }

    private MeterConfig getMeterConfig(InstrumentationScopeInfo instrumentationScopeInfo) {
        MeterConfig meterConfig = (MeterConfig)this.meterConfigurator.apply((MeterConfig)((Object)instrumentationScopeInfo));
        return meterConfig == null ? MeterConfig.defaultConfig() : meterConfig;
    }

    @Override
    public MeterBuilder meterBuilder(String instrumentationScopeName) {
        if (this.registeredReaders.isEmpty()) {
            return MeterProvider.noop().meterBuilder(instrumentationScopeName);
        }
        if (instrumentationScopeName == null || instrumentationScopeName.isEmpty()) {
            LOGGER.fine("Meter requested without instrumentation scope name.");
            instrumentationScopeName = DEFAULT_METER_NAME;
        }
        return new SdkMeterBuilder(this.registry, instrumentationScopeName);
    }

    void resetForTest() {
        this.registry.getComponents().forEach(SdkMeter::resetForTest);
    }

    public CompletableResultCode forceFlush() {
        if (this.registeredReaders.isEmpty()) {
            return CompletableResultCode.ofSuccess();
        }
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>();
        for (RegisteredReader registeredReader : this.registeredReaders) {
            results.add(registeredReader.getReader().forceFlush());
        }
        return CompletableResultCode.ofAll(results);
    }

    public CompletableResultCode shutdown() {
        if (!this.isClosed.compareAndSet(false, true)) {
            LOGGER.info("Multiple close calls");
            return CompletableResultCode.ofSuccess();
        }
        if (this.registeredReaders.isEmpty()) {
            return CompletableResultCode.ofSuccess();
        }
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>();
        for (RegisteredReader info : this.registeredReaders) {
            results.add(info.getReader().shutdown());
        }
        return CompletableResultCode.ofAll(results);
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "SdkMeterProvider{clock=" + this.sharedState.getClock() + ", resource=" + this.sharedState.getResource() + ", metricReaders=" + this.registeredReaders.stream().map(RegisteredReader::getReader).collect(Collectors.toList()) + ", metricProducers=" + this.metricProducers + ", views=" + this.registeredViews + ", meterConfigurator=" + this.meterConfigurator + "}";
    }

    private static class LeasedMetricProducer
    implements MetricProducer {
        private final ComponentRegistry<SdkMeter> registry;
        private final MeterProviderSharedState sharedState;
        private final RegisteredReader registeredReader;

        LeasedMetricProducer(ComponentRegistry<SdkMeter> registry, MeterProviderSharedState sharedState, RegisteredReader registeredReader) {
            this.registry = registry;
            this.sharedState = sharedState;
            this.registeredReader = registeredReader;
        }

        @Override
        public Collection<MetricData> produce(Resource unused) {
            Collection<SdkMeter> meters = this.registry.getComponents();
            ArrayList<MetricData> result = new ArrayList<MetricData>();
            long collectTime = this.sharedState.getClock().now();
            for (SdkMeter meter : meters) {
                result.addAll(meter.collectAll(this.registeredReader, collectTime));
            }
            this.registeredReader.setLastCollectEpochNanos(collectTime);
            return Collections.unmodifiableCollection(result);
        }
    }

    private static class SdkCollectionRegistration
    implements CollectionRegistration {
        private final List<MetricProducer> metricProducers;
        private final MeterProviderSharedState sharedState;

        private SdkCollectionRegistration(List<MetricProducer> metricProducers, MeterProviderSharedState sharedState) {
            this.metricProducers = metricProducers;
            this.sharedState = sharedState;
        }

        @Override
        public Collection<MetricData> collectAllMetrics() {
            if (this.metricProducers.isEmpty()) {
                return Collections.emptyList();
            }
            Resource resource = this.sharedState.getResource();
            if (this.metricProducers.size() == 1) {
                return this.metricProducers.get(0).produce(resource);
            }
            ArrayList<MetricData> metricData = new ArrayList<MetricData>();
            for (MetricProducer metricProducer : this.metricProducers) {
                metricData.addAll(metricProducer.produce(resource));
            }
            return Collections.unmodifiableList(metricData);
        }
    }
}

