/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.data.AggregationTemporality;
import java.util.StringJoiner;

@FunctionalInterface
public interface AggregationTemporalitySelector {
    public static AggregationTemporalitySelector alwaysCumulative() {
        return instrumentType -> AggregationTemporality.CUMULATIVE;
    }

    public static AggregationTemporalitySelector deltaPreferred() {
        return instrumentType -> {
            switch (instrumentType) {
                case UP_DOWN_COUNTER: 
                case OBSERVABLE_UP_DOWN_COUNTER: {
                    return AggregationTemporality.CUMULATIVE;
                }
            }
            return AggregationTemporality.DELTA;
        };
    }

    public static AggregationTemporalitySelector lowMemory() {
        return instrumentType -> {
            switch (instrumentType) {
                case UP_DOWN_COUNTER: 
                case OBSERVABLE_UP_DOWN_COUNTER: 
                case OBSERVABLE_COUNTER: {
                    return AggregationTemporality.CUMULATIVE;
                }
            }
            return AggregationTemporality.DELTA;
        };
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType var1);

    public static String asString(AggregationTemporalitySelector selector) {
        StringJoiner joiner = new StringJoiner(", ", "AggregationTemporalitySelector{", "}");
        for (InstrumentType type : InstrumentType.values()) {
            joiner.add(type.name() + "=" + selector.getAggregationTemporality(type).name());
        }
        return joiner.toString();
    }
}

