/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry.otelmodel;

import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusData;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.SummaryPointDataImpl;
import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.model.snapshots.Quantile;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.data.MetricDataType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.data.SummaryData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.data.SummaryPointData;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class PrometheusSummary
extends PrometheusData<SummaryPointData>
implements SummaryData {
    private final List<SummaryPointData> points;

    PrometheusSummary(SummarySnapshot snapshot, long currentTimeMillis) {
        super(MetricDataType.SUMMARY);
        this.points = snapshot.getDataPoints().stream().map(dataPoint -> this.toOtelDataPoint((SummarySnapshot.SummaryDataPointSnapshot)dataPoint, currentTimeMillis)).collect(Collectors.toList());
    }

    @Override
    public Collection<SummaryPointData> getPoints() {
        return this.points;
    }

    private SummaryPointData toOtelDataPoint(SummarySnapshot.SummaryDataPointSnapshot dataPoint, long currentTimeMillis) {
        SummaryPointDataImpl result = new SummaryPointDataImpl(dataPoint.hasSum() ? dataPoint.getSum() : Double.NaN, dataPoint.hasCount() ? dataPoint.getCount() : 0L, this.getStartEpochNanos((DataPointSnapshot)dataPoint), this.getEpochNanos((DataPointSnapshot)dataPoint, currentTimeMillis), this.labelsToAttributes(dataPoint.getLabels()), this.convertExemplars(dataPoint.getExemplars()));
        for (Quantile quantile : dataPoint.getQuantiles()) {
            result.addValue(quantile.getQuantile(), quantile.getValue());
        }
        return result;
    }
}

