/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.common;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.common.ArrayBackedExtendedAttributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.common.ExtendedAttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.common.ExtendedAttributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.common.ExtendedAttributesBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

class ArrayBackedExtendedAttributesBuilder
implements ExtendedAttributesBuilder {
    private final List<Object> data;

    ArrayBackedExtendedAttributesBuilder() {
        this.data = new ArrayList<Object>();
    }

    ArrayBackedExtendedAttributesBuilder(List<Object> data) {
        this.data = data;
    }

    @Override
    public ExtendedAttributes build() {
        if (this.data.size() == 2 && this.data.get(0) != null) {
            return new ArrayBackedExtendedAttributes(this.data.toArray());
        }
        return ArrayBackedExtendedAttributes.sortAndFilterToAttributes(this.data.toArray());
    }

    @Override
    public <T> ExtendedAttributesBuilder put(ExtendedAttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        this.data.add(key);
        this.data.add(value);
        return this;
    }

    @Override
    public ExtendedAttributesBuilder removeIf(Predicate<ExtendedAttributeKey<?>> predicate) {
        if (predicate == null) {
            return this;
        }
        for (int i = 0; i < this.data.size() - 1; i += 2) {
            Object entry = this.data.get(i);
            if (!(entry instanceof ExtendedAttributeKey) || !predicate.test((ExtendedAttributeKey)entry)) continue;
            this.data.set(i, null);
            this.data.set(i + 1, null);
        }
        return this;
    }

    static List<Double> toList(double ... values2) {
        Double[] boxed = new Double[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            boxed[i] = values2[i];
        }
        return Arrays.asList(boxed);
    }

    static List<Long> toList(long ... values2) {
        Long[] boxed = new Long[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            boxed[i] = values2[i];
        }
        return Arrays.asList(boxed);
    }

    static List<Boolean> toList(boolean ... values2) {
        Boolean[] boxed = new Boolean[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            boxed[i] = values2[i];
        }
        return Arrays.asList(boxed);
    }
}

